/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptEvaluator;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StandardScriptEvaluator;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    public static final String ITEM_BINDING_VARIABLE_NAME = "item";
    private @Nullable String language;
    private @Nullable ScriptSource script;
    private @Nullable ScriptSource scriptSource;
    private @Nullable ScriptEvaluator scriptEvaluator;
    private String itemBindingVariableName = "item";

    @Override
    public @Nullable O process(I item) throws Exception {
        HashMap<String, I> arguments = new HashMap<String, I>();
        arguments.put(this.itemBindingVariableName, item);
        return (O)this.scriptEvaluator.evaluate(this.getScriptSource(), arguments);
    }

    public void setScript(Resource resource) {
        Assert.notNull((Object)resource, (String)"The script resource cannot be null");
        this.script = new ResourceScriptSource(resource);
    }

    public void setScriptSource(String scriptSource, String language) {
        Assert.hasText((String)language, (String)"Language must contain the script language");
        Assert.hasText((String)scriptSource, (String)"Script source must contain the script source to evaluate");
        this.language = language;
        this.scriptSource = new StaticScriptSource(scriptSource);
    }

    public void setItemBindingVariableName(String itemBindingVariableName) {
        this.itemBindingVariableName = itemBindingVariableName;
    }

    public void setScriptEvaluator(ScriptEvaluator scriptEvaluator) {
        this.scriptEvaluator = scriptEvaluator;
    }

    public void afterPropertiesSet() throws Exception {
        ScriptEvaluator scriptEvaluator;
        if (this.scriptEvaluator == null) {
            this.scriptEvaluator = new StandardScriptEvaluator();
        }
        Assert.state((this.scriptSource != null || this.script != null ? 1 : 0) != 0, (String)"Either the script source or script file must be provided");
        Assert.state((this.scriptSource == null || this.script == null ? 1 : 0) != 0, (String)"Either a script source or script file must be provided, not both");
        if (this.scriptSource != null && (scriptEvaluator = this.scriptEvaluator) instanceof StandardScriptEvaluator) {
            StandardScriptEvaluator standardScriptEvaluator = (StandardScriptEvaluator)scriptEvaluator;
            Assert.state((boolean)StringUtils.hasLength((String)this.language), (String)"Language must be provided when using the default ScriptEvaluator and raw source code");
            standardScriptEvaluator.setLanguage(this.language);
        }
    }

    private ScriptSource getScriptSource() {
        if (this.script != null) {
            return this.script;
        }
        if (this.scriptSource != null) {
            return this.scriptSource;
        }
        throw new IllegalStateException("Either a script source or script needs to be provided.");
    }
}

