/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.transform.FieldSet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@NullUnmarked
public class DefaultFieldSet
implements FieldSet {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private @Nullable String grouping;
    private @Nullable String decimal;
    private final @Nullable String[] tokens;
    private @Nullable List<String> names;
    private @Nullable Map<String, Integer> nameIndexMap;

    public DefaultFieldSet(@Nullable String @Nullable [] tokens) {
        this(tokens, null, null);
    }

    public DefaultFieldSet(@Nullable String @Nullable [] tokens, @Nullable DateFormat dateFormat, @Nullable NumberFormat numberFormat) {
        this.tokens = tokens != null ? (String[])tokens.clone() : new String[]{};
        this.dateFormat = dateFormat != null ? dateFormat : DefaultFieldSet.getDefaultDateFormat();
        this.setNumberFormat(numberFormat != null ? numberFormat : DefaultFieldSet.getDefaultNumberFormat());
    }

    public DefaultFieldSet(@Nullable String[] tokens, String[] names) {
        this(tokens, names, DefaultFieldSet.getDefaultDateFormat(), DefaultFieldSet.getDefaultNumberFormat());
    }

    public DefaultFieldSet(@Nullable String[] tokens, String[] names, @Nullable DateFormat dateFormat, @Nullable NumberFormat numberFormat) {
        Assert.notNull((Object)tokens, (String)"Tokens must not be null");
        Assert.notNull((Object)names, (String)"Names must not be null");
        if (tokens.length != names.length) {
            throw new IllegalArgumentException("Field names must be same length as values: names=" + String.valueOf(Arrays.asList(names)) + ", values=" + String.valueOf(Arrays.asList(tokens)));
        }
        this.tokens = (String[])tokens.clone();
        this.names = Arrays.asList(names);
        this.nameIndexMap = new HashMap<String, Integer>(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.nameIndexMap.put(names[i], i);
        }
        this.dateFormat = dateFormat != null ? dateFormat : DefaultFieldSet.getDefaultDateFormat();
        this.setNumberFormat(numberFormat != null ? numberFormat : DefaultFieldSet.getDefaultNumberFormat());
    }

    private static DateFormat getDefaultDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    private static NumberFormat getDefaultNumberFormat() {
        return NumberFormat.getInstance(Locale.US);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            this.grouping = String.valueOf(decimalFormat.getDecimalFormatSymbols().getGroupingSeparator());
            this.decimal = String.valueOf(decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
        }
    }

    @Override
    public String[] getNames() {
        if (this.names == null) {
            throw new IllegalStateException("Field names are not known");
        }
        return this.names.toArray(new String[0]);
    }

    @Override
    public boolean hasNames() {
        return this.names != null;
    }

    @Override
    public @Nullable String[] getValues() {
        return (String[])this.tokens.clone();
    }

    @Override
    public @Nullable String readString(int index) {
        return this.readAndTrim(index);
    }

    @Override
    public @Nullable String readString(String name) {
        return this.readString(this.indexOf(name));
    }

    @Override
    public @Nullable String readRawString(int index) {
        return this.tokens[index];
    }

    @Override
    public @Nullable String readRawString(String name) {
        return this.readRawString(this.indexOf(name));
    }

    @Override
    public boolean readBoolean(int index) {
        return this.readBoolean(index, "true");
    }

    @Override
    public boolean readBoolean(String name) {
        return this.readBoolean(this.indexOf(name));
    }

    @Override
    public boolean readBoolean(int index, String trueValue) {
        Assert.notNull((Object)trueValue, (String)"'trueValue' cannot be null.");
        return trueValue.equals(this.readAndTrim(index));
    }

    @Override
    public boolean readBoolean(String name, String trueValue) {
        return this.readBoolean(this.indexOf(name), trueValue);
    }

    @Override
    public char readChar(int index) {
        String value = Objects.requireNonNull(this.readAndTrim(index));
        Assert.isTrue((value.length() == 1 ? 1 : 0) != 0, (String)("Cannot convert field value '" + value + "' to char."));
        return value.charAt(0);
    }

    @Override
    public char readChar(String name) {
        return this.readChar(this.indexOf(name));
    }

    @Override
    public byte readByte(int index) {
        return Byte.parseByte(Objects.requireNonNull(this.readAndTrim(index)));
    }

    @Override
    public byte readByte(String name) {
        return this.readByte(this.indexOf(name));
    }

    @Override
    public short readShort(int index) {
        return Short.parseShort(Objects.requireNonNull(this.readAndTrim(index)));
    }

    @Override
    public short readShort(String name) {
        return this.readShort(this.indexOf(name));
    }

    @Override
    public int readInt(int index) {
        return this.parseNumber(Objects.requireNonNull(this.readAndTrim(index))).intValue();
    }

    @Override
    public int readInt(String name) {
        return this.readInt(this.indexOf(name));
    }

    @Override
    public int readInt(int index, int defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Integer.parseInt(value) : defaultValue;
    }

    @Override
    public int readInt(String name, int defaultValue) {
        return this.readInt(this.indexOf(name), defaultValue);
    }

    @Override
    public long readLong(int index) {
        return this.parseNumber(Objects.requireNonNull(this.readAndTrim(index))).longValue();
    }

    @Override
    public long readLong(String name) {
        return this.readLong(this.indexOf(name));
    }

    @Override
    public long readLong(int index, long defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Long.parseLong(value) : defaultValue;
    }

    @Override
    public long readLong(String name, long defaultValue) {
        return this.readLong(this.indexOf(name), defaultValue);
    }

    @Override
    public float readFloat(int index) {
        return this.parseNumber(Objects.requireNonNull(this.readAndTrim(index))).floatValue();
    }

    @Override
    public float readFloat(String name) {
        return this.readFloat(this.indexOf(name));
    }

    @Override
    public double readDouble(int index) {
        return this.parseNumber(Objects.requireNonNull(this.readAndTrim(index))).doubleValue();
    }

    @Override
    public double readDouble(String name) {
        return this.readDouble(this.indexOf(name));
    }

    @Override
    public @Nullable BigDecimal readBigDecimal(int index) {
        return this.readBigDecimal(index, null);
    }

    @Override
    public @Nullable BigDecimal readBigDecimal(String name) {
        return this.readBigDecimal(name, null);
    }

    @Override
    public @Nullable BigDecimal readBigDecimal(int index, @Nullable BigDecimal defaultValue) {
        String candidate = this.readAndTrim(index);
        if (!StringUtils.hasText((String)candidate)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(this.removeSeparators(candidate));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Unparseable number: " + candidate);
        }
    }

    private String removeSeparators(String candidate) {
        return candidate.replace(this.grouping, "").replace(this.decimal, ".");
    }

    @Override
    public @Nullable BigDecimal readBigDecimal(String name, @Nullable BigDecimal defaultValue) {
        try {
            return this.readBigDecimal(this.indexOf(name), defaultValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage() + ", name: [" + name + "]");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(int index) {
        return this.parseDate(Objects.requireNonNull(this.readAndTrim(index)), this.dateFormat);
    }

    @Override
    public Date readDate(int index, Date defaultValue) {
        String candidate = this.readAndTrim(index);
        return StringUtils.hasText((String)candidate) ? this.parseDate(candidate, this.dateFormat) : defaultValue;
    }

    @Override
    public Date readDate(String name) {
        try {
            return this.readDate(this.indexOf(name));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(String name, Date defaultValue) {
        try {
            return this.readDate(this.indexOf(name), defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(int index, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return this.parseDate(Objects.requireNonNull(this.readAndTrim(index)), sdf);
    }

    @Override
    public Date readDate(int index, String pattern, Date defaultValue) {
        String candidate = this.readAndTrim(index);
        return StringUtils.hasText((String)candidate) ? this.readDate(index, pattern) : defaultValue;
    }

    @Override
    public Date readDate(String name, String pattern) {
        try {
            return this.readDate(this.indexOf(name), pattern);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date readDate(String name, String pattern, Date defaultValue) {
        try {
            return this.readDate(this.indexOf(name), pattern, defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public int getFieldCount() {
        return this.tokens.length;
    }

    protected @Nullable String readAndTrim(int index) {
        String value = this.tokens[index];
        return value != null ? value.trim() : null;
    }

    protected int indexOf(String name) {
        if (this.nameIndexMap == null) {
            throw new IllegalArgumentException("Cannot access columns by name without meta data");
        }
        Integer index = this.nameIndexMap.get(name);
        if (index != null) {
            return index;
        }
        throw new IllegalArgumentException("Cannot access column [" + name + "] from " + String.valueOf(this.names));
    }

    public String toString() {
        if (this.names != null) {
            return this.getProperties().toString();
        }
        return Arrays.toString(this.tokens);
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultFieldSet) {
            DefaultFieldSet fs = (DefaultFieldSet)object;
            return Arrays.equals(this.tokens, fs.tokens);
        }
        return false;
    }

    public int hashCode() {
        if (this.tokens.length == 0) {
            return 0;
        }
        int result = 1;
        for (String token : this.tokens) {
            result = 31 * result + (token == null ? 0 : token.hashCode());
        }
        return result;
    }

    @Override
    public Properties getProperties() {
        if (this.names == null) {
            throw new IllegalStateException("Cannot create properties without meta data");
        }
        Properties props = new Properties();
        for (int i = 0; i < this.tokens.length; ++i) {
            String value = this.readAndTrim(i);
            if (value == null) continue;
            props.setProperty(this.names.get(i), value);
        }
        return props;
    }

    private Number parseNumber(String input) {
        try {
            return this.numberFormat.parse(input);
        }
        catch (ParseException e) {
            throw new NumberFormatException("Unparseable number: " + input);
        }
    }

    private Date parseDate(String input, DateFormat dateFormat) {
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            String string;
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                string = sdf.toPattern();
            } else {
                string = dateFormat.toString();
            }
            String pattern = string;
            throw new IllegalArgumentException(e.getMessage() + ", format: [" + pattern + "]");
        }
    }
}

