/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.builder;

import java.util.Map;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.JdbcPagingItemReader;
import org.springframework.batch.infrastructure.item.database.Order;
import org.springframework.batch.infrastructure.item.database.PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.Db2PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.DerbyPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.H2PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.HanaPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.HsqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.MariaDBPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.OraclePagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.PostgresPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SqlServerPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SqlitePagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SybasePagingQueryProvider;
import org.springframework.batch.infrastructure.support.DatabaseType;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.DataClassRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;

public class JdbcPagingItemReaderBuilder<T> {
    protected @Nullable DataSource dataSource;
    protected int fetchSize = -1;
    protected @Nullable PagingQueryProvider queryProvider;
    protected @Nullable RowMapper<T> rowMapper;
    protected @Nullable Map<String, Object> parameterValues;
    protected int pageSize = 10;
    protected @Nullable String groupClause;
    protected @Nullable String selectClause;
    protected @Nullable String fromClause;
    protected @Nullable String whereClause;
    protected @Nullable Map<String, Order> sortKeys;
    protected boolean saveState = true;
    protected @Nullable String name;
    protected int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JdbcPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> rowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> beanRowMapper(Class<T> mappedClass) {
        this.rowMapper = new BeanPropertyRowMapper(mappedClass);
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> dataRowMapper(Class<T> mappedClass) {
        this.rowMapper = new DataClassRowMapper(mappedClass);
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> groupClause(String groupClause) {
        this.groupClause = groupClause;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> selectClause(String selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> fromClause(String fromClause) {
        this.fromClause = fromClause;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> whereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> sortKeys(Map<String, Order> sortKeys) {
        this.sortKeys = sortKeys;
        return this;
    }

    public JdbcPagingItemReaderBuilder<T> queryProvider(PagingQueryProvider provider) {
        this.queryProvider = provider;
        return this;
    }

    public JdbcPagingItemReader<T> build() throws Exception {
        Assert.isTrue((this.pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
        Assert.notNull((Object)this.dataSource, (String)"dataSource is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        JdbcPagingItemReader<T> reader = new JdbcPagingItemReader<T>(this.dataSource, this.queryProvider == null ? this.determineQueryProvider(this.dataSource) : this.queryProvider);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setCurrentItemCount(this.currentItemCount);
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setSaveState(this.saveState);
        reader.setFetchSize(this.fetchSize);
        if (this.parameterValues != null) {
            reader.setParameterValues(this.parameterValues);
        }
        if (this.rowMapper != null) {
            reader.setRowMapper(this.rowMapper);
        }
        reader.setPageSize(this.pageSize);
        reader.afterPropertiesSet();
        return reader;
    }

    protected PagingQueryProvider determineQueryProvider(DataSource dataSource) {
        Assert.hasLength((String)this.selectClause, (String)"selectClause is required when not providing a PagingQueryProvider");
        Assert.hasLength((String)this.fromClause, (String)"fromClause is required when not providing a PagingQueryProvider");
        Assert.notEmpty(this.sortKeys, (String)"sortKeys are required when not providing a PagingQueryProvider");
        try {
            DatabaseType databaseType = DatabaseType.fromMetaData(dataSource);
            AbstractSqlPagingQueryProvider provider = switch (databaseType) {
                default -> throw new IncompatibleClassChangeError();
                case DatabaseType.DERBY -> new DerbyPagingQueryProvider();
                case DatabaseType.DB2, DatabaseType.DB2VSE, DatabaseType.DB2ZOS, DatabaseType.DB2AS400 -> new Db2PagingQueryProvider();
                case DatabaseType.H2 -> new H2PagingQueryProvider();
                case DatabaseType.HANA -> new HanaPagingQueryProvider();
                case DatabaseType.HSQL -> new HsqlPagingQueryProvider();
                case DatabaseType.SQLSERVER -> new SqlServerPagingQueryProvider();
                case DatabaseType.MYSQL -> new MySqlPagingQueryProvider();
                case DatabaseType.MARIADB -> new MariaDBPagingQueryProvider();
                case DatabaseType.ORACLE -> new OraclePagingQueryProvider();
                case DatabaseType.POSTGRES -> new PostgresPagingQueryProvider();
                case DatabaseType.SYBASE -> new SybasePagingQueryProvider();
                case DatabaseType.SQLITE -> new SqlitePagingQueryProvider();
            };
            provider.setSelectClause(this.selectClause);
            provider.setFromClause(this.fromClause);
            provider.setWhereClause(this.whereClause);
            provider.setGroupClause(this.groupClause);
            provider.setSortKeys(this.sortKeys);
            return provider;
        }
        catch (MetaDataAccessException e) {
            throw new IllegalArgumentException("Unable to determine PagingQueryProvider type", e);
        }
    }
}

