/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.DirectReplyToMessageListenerContainer;

public abstract class RabbitFuture<T>
extends CompletableFuture<T> {
    private final String correlationId;
    private final Message requestMessage;
    private final BiConsumer<String, DirectReplyToMessageListenerContainer.ChannelHolder> canceler;
    private final Function<RabbitFuture<?>, ScheduledFuture<?>> timeoutTaskFunction;
    private ScheduledFuture<?> timeoutTask;
    private volatile CompletableFuture<Boolean> confirm;
    private String nackCause;
    private DirectReplyToMessageListenerContainer.ChannelHolder channelHolder;

    protected RabbitFuture(String correlationId, Message requestMessage, BiConsumer<String, DirectReplyToMessageListenerContainer.ChannelHolder> canceler, Function<RabbitFuture<?>, ScheduledFuture<?>> timeoutTaskFunction) {
        this.correlationId = correlationId;
        this.requestMessage = requestMessage;
        this.canceler = canceler;
        this.timeoutTaskFunction = timeoutTaskFunction;
    }

    void setChannelHolder(DirectReplyToMessageListenerContainer.ChannelHolder channel) {
        this.channelHolder = channel;
    }

    String getCorrelationId() {
        return this.correlationId;
    }

    DirectReplyToMessageListenerContainer.ChannelHolder getChannelHolder() {
        return this.channelHolder;
    }

    Message getRequestMessage() {
        return this.requestMessage;
    }

    @Override
    public boolean complete(T value) {
        try {
            boolean bl = super.complete(value);
            return bl;
        }
        finally {
            this.cancelTimeoutTaskIfAny();
        }
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        try {
            boolean bl = super.completeExceptionally(ex);
            return bl;
        }
        finally {
            this.cancelTimeoutTaskIfAny();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.canceler.accept(this.correlationId, this.channelHolder);
        try {
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.cancelTimeoutTaskIfAny();
        }
    }

    private void cancelTimeoutTaskIfAny() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(true);
        }
    }

    public CompletableFuture<Boolean> getConfirm() {
        return this.confirm;
    }

    void setConfirm(CompletableFuture<Boolean> confirm) {
        this.confirm = confirm;
    }

    public String getNackCause() {
        return this.nackCause;
    }

    void setNackCause(String nackCause) {
        this.nackCause = nackCause;
    }

    void startTimer() {
        this.timeoutTask = this.timeoutTaskFunction.apply(this);
    }
}

