/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.context;

import org.springframework.amqp.rabbit.annotation.RabbitBootstrapConfiguration;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.junit.BrokerRunningSupport;
import org.springframework.amqp.rabbit.junit.RabbitAvailableCondition;
import org.springframework.amqp.rabbit.test.context.SpringRabbitTest;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class SpringRabbitContextCustomizer
implements ContextCustomizer {
    private final SpringRabbitTest springRabbitTest;

    SpringRabbitContextCustomizer(SpringRabbitTest test) {
        this.springRabbitTest = test;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        CachingConnectionFactory cf;
        Assert.isInstanceOf(GenericApplicationContext.class, (Object)context);
        GenericApplicationContext applicationContext = (GenericApplicationContext)context;
        BrokerRunningSupport brokerRunning = RabbitAvailableCondition.getBrokerRunning();
        if (brokerRunning != null) {
            cf = new CachingConnectionFactory(brokerRunning.getConnectionFactory());
        } else {
            cf = new CachingConnectionFactory(this.springRabbitTest.host(), this.springRabbitTest.port());
            cf.setUsername(this.springRabbitTest.user());
            cf.setPassword(this.springRabbitTest.password());
        }
        applicationContext.registerBean("autoConnectionFactory", CachingConnectionFactory.class, () -> cf, new BeanDefinitionCustomizer[0]);
        applicationContext.registerBean("autoRabbitTemplate", RabbitTemplate.class, () -> new RabbitTemplate((ConnectionFactory)cf), new BeanDefinitionCustomizer[0]);
        applicationContext.registerBean("autoRabbitAdmin", RabbitAdmin.class, () -> new RabbitAdmin((ConnectionFactory)cf), new BeanDefinitionCustomizer[0]);
        Object factory = this.springRabbitTest.containerType().equals((Object)SpringRabbitTest.ContainerType.simple) ? new SimpleRabbitListenerContainerFactory() : new DirectRabbitListenerContainerFactory();
        factory.setConnectionFactory((ConnectionFactory)cf);
        applicationContext.registerBean("autoContainerFactory", AbstractRabbitListenerContainerFactory.class, () -> SpringRabbitContextCustomizer.lambda$customizeContext$3((AbstractRabbitListenerContainerFactory)factory), new BeanDefinitionCustomizer[0]);
        new RabbitBootstrapConfiguration().registerBeanDefinitions(null, (BeanDefinitionRegistry)applicationContext.getBeanFactory());
    }

    private static /* synthetic */ AbstractRabbitListenerContainerFactory lambda$customizeContext$3(AbstractRabbitListenerContainerFactory factory) {
        return factory;
    }
}

