/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.azure.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiAudioTranscriptionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiChatProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiImageOptionsProperties;
import org.springframework.ai.azure.openai.AzureOpenAiAudioTranscriptionModel;
import org.springframework.ai.azure.openai.AzureOpenAiChatModel;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.azure.openai.AzureOpenAiImageModel;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.function.DefaultFunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={OpenAIClientBuilder.class, AzureOpenAiChatModel.class})
@EnableConfigurationProperties(value={AzureOpenAiChatProperties.class, AzureOpenAiEmbeddingProperties.class, AzureOpenAiConnectionProperties.class, AzureOpenAiImageOptionsProperties.class, AzureOpenAiAudioTranscriptionProperties.class})
public class AzureOpenAiAutoConfiguration {
    private static final String APPLICATION_ID = "spring-ai";

    @Bean
    @ConditionalOnMissingBean
    public OpenAIClientBuilder openAIClientBuilder(AzureOpenAiConnectionProperties connectionProperties) {
        if (StringUtils.hasText((String)connectionProperties.getApiKey())) {
            Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
            Map<String, String> customHeaders = connectionProperties.getCustomHeaders();
            List headers = customHeaders.entrySet().stream().map(entry -> new Header((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            ClientOptions clientOptions = new ClientOptions().setApplicationId(APPLICATION_ID).setHeaders(headers);
            return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((KeyCredential)new AzureKeyCredential(connectionProperties.getApiKey())).clientOptions(clientOptions);
        }
        if (StringUtils.hasText((String)connectionProperties.getOpenAiApiKey())) {
            return new OpenAIClientBuilder().endpoint("https://api.openai.com/v1").credential(new KeyCredential(connectionProperties.getOpenAiApiKey())).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID));
        }
        throw new IllegalArgumentException("Either API key or OpenAI API key must not be empty");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={TokenCredential.class})
    public OpenAIClientBuilder openAIClientWithTokenCredential(AzureOpenAiConnectionProperties connectionProperties, TokenCredential tokenCredential) {
        Assert.notNull((Object)tokenCredential, (String)"TokenCredential must not be null");
        Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
        return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential(tokenCredential).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiChatModel azureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatProperties chatProperties, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackResolver functionCallbackResolver, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        AzureOpenAiChatModel chatModel = new AzureOpenAiChatModel(openAIClientBuilder, chatProperties.getOptions(), functionCallbackResolver, toolFunctionCallbacks, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((AzureOpenAiChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiEmbeddingModel azureOpenAiEmbeddingModel(OpenAIClientBuilder openAIClient, AzureOpenAiEmbeddingProperties embeddingProperties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        AzureOpenAiEmbeddingModel embeddingModel = new AzureOpenAiEmbeddingModel(openAIClient.buildClient(), embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((AzureOpenAiEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackResolver springAiFunctionManager(ApplicationContext context) {
        DefaultFunctionCallbackResolver manager = new DefaultFunctionCallbackResolver();
        manager.setApplicationContext(context);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiImageModel azureOpenAiImageClient(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiImageOptionsProperties imageProperties) {
        return new AzureOpenAiImageModel(openAIClientBuilder.buildClient(), imageProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.audio.transcription", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiAudioTranscriptionModel azureOpenAiAudioTranscriptionModel(OpenAIClientBuilder openAIClient, AzureOpenAiAudioTranscriptionProperties audioProperties) {
        return new AzureOpenAiAudioTranscriptionModel(openAIClient.buildClient(), audioProperties.getOptions());
    }
}

