/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.mongodb.atlas;

import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.lang.NonNull;

record VectorSearchAggregation(List<Float> embeddings, String path, int numCandidates, String index, int count, String filter) implements AggregationOperation
{
    public Document toDocument(@NonNull AggregationOperationContext context) {
        Document vectorSearch = new Document("queryVector", this.embeddings).append("path", (Object)this.path).append("numCandidates", (Object)this.numCandidates).append("index", (Object)this.index).append("limit", (Object)this.count);
        if (!this.filter.isEmpty()) {
            vectorSearch.append("filter", (Object)Document.parse((String)this.filter));
        }
        Document doc = new Document("$vectorSearch", (Object)vectorSearch);
        return context.getMappedObject(doc);
    }
}

