/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.micrometer.common.util.StringUtils;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.mcp.AsyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.SyncMcpToolCallbackProvider;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class McpToolUtils {
    public static final String TOOL_CONTEXT_MCP_EXCHANGE_KEY = "exchange";

    private McpToolUtils() {
    }

    public static String prefixedToolName(String prefix, String title, String toolName) {
        if (StringUtils.isEmpty((String)prefix) || StringUtils.isEmpty((String)toolName)) {
            throw new IllegalArgumentException("Prefix or toolName cannot be null or empty");
        }
        Object input = McpToolUtils.shorten(McpToolUtils.format(prefix));
        if (!StringUtils.isEmpty((String)title)) {
            input = (String)input + "_" + McpToolUtils.format(title);
        }
        if (((String)(input = (String)input + "_" + McpToolUtils.format(toolName))).length() > 64) {
            input = ((String)input).substring(((String)input).length() - 64);
        }
        return input;
    }

    public static String prefixedToolName(String prefix, String toolName) {
        return McpToolUtils.prefixedToolName(prefix, null, toolName);
    }

    public static String format(String input) {
        String formatted = input.replaceAll("[^\\p{IsHan}\\p{InCJK_Unified_Ideographs}\\p{InCJK_Compatibility_Ideographs}a-zA-Z0-9_-]", "");
        return formatted.replaceAll("-", "_");
    }

    private static String shorten(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return Stream.of(input.toLowerCase().split("_")).filter(word -> !word.isEmpty()).map(word -> String.valueOf(word.charAt(0))).collect(Collectors.joining("_"));
    }

    public static List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecification(List<ToolCallback> toolCallbacks) {
        return toolCallbacks.stream().map(McpToolUtils::toSyncToolSpecification).toList();
    }

    public static List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecifications(ToolCallback ... toolCallbacks) {
        return McpToolUtils.toSyncToolSpecification(List.of(toolCallbacks));
    }

    public static McpServerFeatures.SyncToolSpecification toSyncToolSpecification(ToolCallback toolCallback) {
        return McpToolUtils.toSyncToolSpecification(toolCallback, null);
    }

    public static McpServerFeatures.SyncToolSpecification toSyncToolSpecification(ToolCallback toolCallback, MimeType mimeType) {
        SharedSyncToolSpecification sharedSpec = McpToolUtils.toSharedSyncToolSpecification(toolCallback, mimeType);
        return new McpServerFeatures.SyncToolSpecification(sharedSpec.tool(), (exchange, map) -> sharedSpec.sharedHandler().apply(exchange, new McpSchema.CallToolRequest(sharedSpec.tool().name(), map)), (exchange, request) -> sharedSpec.sharedHandler().apply(exchange, (McpSchema.CallToolRequest)request));
    }

    public static McpStatelessServerFeatures.SyncToolSpecification toStatelessSyncToolSpecification(ToolCallback toolCallback, MimeType mimeType) {
        SharedSyncToolSpecification sharedSpec = McpToolUtils.toSharedSyncToolSpecification(toolCallback, mimeType);
        return McpStatelessServerFeatures.SyncToolSpecification.builder().tool(sharedSpec.tool()).callHandler((exchange, request) -> sharedSpec.sharedHandler().apply(exchange, (McpSchema.CallToolRequest)request)).build();
    }

    private static SharedSyncToolSpecification toSharedSyncToolSpecification(ToolCallback toolCallback, MimeType mimeType) {
        McpSchema.Tool tool = McpSchema.Tool.builder().name(toolCallback.getToolDefinition().name()).description(toolCallback.getToolDefinition().description()).inputSchema((McpSchema.JsonSchema)ModelOptionsUtils.jsonToObject((String)toolCallback.getToolDefinition().inputSchema(), McpSchema.JsonSchema.class)).build();
        return new SharedSyncToolSpecification(tool, (exchangeOrContext, request) -> {
            try {
                String callResult = toolCallback.call(ModelOptionsUtils.toJsonString((Object)request.arguments()), new ToolContext(Map.of(TOOL_CONTEXT_MCP_EXCHANGE_KEY, exchangeOrContext)));
                if (mimeType != null && mimeType.toString().startsWith("image")) {
                    McpSchema.Annotations annotations = new McpSchema.Annotations(List.of(McpSchema.Role.ASSISTANT), null);
                    return new McpSchema.CallToolResult(List.of(new McpSchema.ImageContent(annotations, callResult, mimeType.toString())), Boolean.valueOf(false));
                }
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(callResult)), Boolean.valueOf(false));
            }
            catch (Exception e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(e.getMessage())), Boolean.valueOf(true));
            }
        });
    }

    public static Optional<McpSyncServerExchange> getMcpExchange(ToolContext toolContext) {
        if (toolContext != null && toolContext.getContext().containsKey(TOOL_CONTEXT_MCP_EXCHANGE_KEY)) {
            return Optional.ofNullable((McpSyncServerExchange)toolContext.getContext().get(TOOL_CONTEXT_MCP_EXCHANGE_KEY));
        }
        return Optional.empty();
    }

    public static List<McpServerFeatures.AsyncToolSpecification> toAsyncToolSpecifications(List<ToolCallback> toolCallbacks) {
        return toolCallbacks.stream().map(McpToolUtils::toAsyncToolSpecification).toList();
    }

    public static List<McpServerFeatures.AsyncToolSpecification> toAsyncToolSpecifications(ToolCallback ... toolCallbacks) {
        return McpToolUtils.toAsyncToolSpecifications(List.of(toolCallbacks));
    }

    public static McpServerFeatures.AsyncToolSpecification toAsyncToolSpecification(ToolCallback toolCallback) {
        return McpToolUtils.toAsyncToolSpecification(toolCallback, null);
    }

    public static McpServerFeatures.AsyncToolSpecification toAsyncToolSpecification(ToolCallback toolCallback, MimeType mimeType) {
        McpServerFeatures.SyncToolSpecification syncToolSpecification = McpToolUtils.toSyncToolSpecification(toolCallback, mimeType);
        return McpServerFeatures.AsyncToolSpecification.builder().tool(syncToolSpecification.tool()).callHandler((exchange, request) -> Mono.fromCallable(() -> (McpSchema.CallToolResult)syncToolSpecification.callHandler().apply(new McpSyncServerExchange(exchange), request)).subscribeOn(Schedulers.boundedElastic())).build();
    }

    public static McpStatelessServerFeatures.AsyncToolSpecification toStatelessAsyncToolSpecification(ToolCallback toolCallback, MimeType mimeType) {
        McpStatelessServerFeatures.SyncToolSpecification statelessSyncToolSpecification = McpToolUtils.toStatelessSyncToolSpecification(toolCallback, mimeType);
        return new McpStatelessServerFeatures.AsyncToolSpecification(statelessSyncToolSpecification.tool(), (context, request) -> Mono.fromCallable(() -> (McpSchema.CallToolResult)statelessSyncToolSpecification.callHandler().apply(context, request)).subscribeOn(Schedulers.boundedElastic()));
    }

    public static List<ToolCallback> getToolCallbacksFromSyncClients(McpSyncClient ... mcpClients) {
        return McpToolUtils.getToolCallbacksFromSyncClients(List.of(mcpClients));
    }

    public static List<ToolCallback> getToolCallbacksFromSyncClients(List<McpSyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return List.of();
        }
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    public static List<ToolCallback> getToolCallbacksFromAsyncClients(McpAsyncClient ... asyncMcpClients) {
        return McpToolUtils.getToolCallbacksFromAsyncClients(List.of(asyncMcpClients));
    }

    public static List<ToolCallback> getToolCallbacksFromAsyncClients(List<McpAsyncClient> asyncMcpClients) {
        if (CollectionUtils.isEmpty(asyncMcpClients)) {
            return List.of();
        }
        return List.of(AsyncMcpToolCallbackProvider.builder().mcpClients(asyncMcpClients).build().getToolCallbacks());
    }

    private record SharedSyncToolSpecification(McpSchema.Tool tool, BiFunction<Object, McpSchema.CallToolRequest, McpSchema.CallToolResult> sharedHandler) {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record Base64Wrapper(@JsonAlias(value={"mimetype"}) @Nullable MimeType mimeType, @JsonAlias(value={"base64", "b64", "imageData"}) @Nullable String data) {
    }
}

