/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring;

import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpElicitation;
import org.springaicommunity.mcp.annotation.McpLogging;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.annotation.McpPromptListChanged;
import org.springaicommunity.mcp.annotation.McpResourceListChanged;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springaicommunity.mcp.annotation.McpToolListChanged;
import org.springaicommunity.mcp.method.changed.prompt.AsyncPromptListChangedSpecification;
import org.springaicommunity.mcp.method.changed.resource.AsyncResourceListChangedSpecification;
import org.springaicommunity.mcp.method.changed.tool.AsyncToolListChangedSpecification;
import org.springaicommunity.mcp.method.elicitation.AsyncElicitationSpecification;
import org.springaicommunity.mcp.method.logging.AsyncLoggingSpecification;
import org.springaicommunity.mcp.method.progress.AsyncProgressSpecification;
import org.springaicommunity.mcp.method.sampling.AsyncSamplingSpecification;
import org.springframework.ai.mcp.annotation.spring.AbstractClientMcpHandlerRegistry;
import org.springframework.ai.mcp.annotation.spring.AsyncMcpAnnotationProviders;
import org.springframework.beans.factory.SmartInitializingSingleton;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClientMcpAsyncHandlersRegistry
extends AbstractClientMcpHandlerRegistry
implements SmartInitializingSingleton {
    private static final Logger logger = LoggerFactory.getLogger(ClientMcpAsyncHandlersRegistry.class);
    private final Map<String, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>>> samplingHandlers = new HashMap<String, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>>>();
    private final Map<String, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>>> elicitationHandlers = new HashMap<String, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>>>();
    private final Map<String, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>> loggingHandlers = new HashMap<String, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>>();
    private final Map<String, List<Function<McpSchema.ProgressNotification, Mono<Void>>>> progressHandlers = new HashMap<String, List<Function<McpSchema.ProgressNotification, Mono<Void>>>>();
    private final Map<String, List<Function<List<McpSchema.Tool>, Mono<Void>>>> toolListChangedHandlers = new HashMap<String, List<Function<List<McpSchema.Tool>, Mono<Void>>>>();
    private final Map<String, List<Function<List<McpSchema.Prompt>, Mono<Void>>>> promptListChangedHandlers = new HashMap<String, List<Function<List<McpSchema.Prompt>, Mono<Void>>>>();
    private final Map<String, List<Function<List<McpSchema.Resource>, Mono<Void>>>> resourceListChangedHandlers = new HashMap<String, List<Function<List<McpSchema.Resource>, Mono<Void>>>>();

    public McpSchema.ClientCapabilities getCapabilities(String clientName) {
        return this.capabilitiesPerClient.getOrDefault(clientName, EMPTY_CAPABILITIES);
    }

    public Mono<McpSchema.CreateMessageResult> handleSampling(String name, McpSchema.CreateMessageRequest samplingRequest) {
        logger.debug("Handling sampling request for client {}", (Object)name);
        Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> handler = this.samplingHandlers.get(name);
        if (handler != null) {
            return handler.apply(samplingRequest);
        }
        return Mono.error((Throwable)new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(Integer.valueOf(-32601), "Sampling not supported", Map.of("reason", "Client does not have sampling capability"))));
    }

    public Mono<McpSchema.ElicitResult> handleElicitation(String name, McpSchema.ElicitRequest elicitationRequest) {
        logger.debug("Handling elicitation request for client {}", (Object)name);
        Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> handler = this.elicitationHandlers.get(name);
        if (handler != null) {
            return handler.apply(elicitationRequest);
        }
        return Mono.error((Throwable)new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(Integer.valueOf(-32601), "Elicitation not supported", Map.of("reason", "Client does not have elicitation capability"))));
    }

    public Mono<Void> handleLogging(String name, McpSchema.LoggingMessageNotification loggingMessageNotification) {
        logger.debug("Handling logging notification for client {}", (Object)name);
        List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> consumers = this.loggingHandlers.get(name);
        if (consumers == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(consumers).flatMap(c -> (Publisher)c.apply(loggingMessageNotification)).then();
    }

    public Mono<Void> handleProgress(String name, McpSchema.ProgressNotification progressNotification) {
        logger.debug("Handling progress notification for client {}", (Object)name);
        List<Function<McpSchema.ProgressNotification, Mono<Void>>> consumers = this.progressHandlers.get(name);
        if (consumers == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(consumers).flatMap(c -> (Publisher)c.apply(progressNotification)).then();
    }

    public Mono<Void> handleToolListChanged(String name, List<McpSchema.Tool> updatedTools) {
        logger.debug("Handling tool list changed notification for client {}", (Object)name);
        List<Function<List<McpSchema.Tool>, Mono<Void>>> consumers = this.toolListChangedHandlers.get(name);
        if (consumers == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(consumers).flatMap(c -> (Publisher)c.apply(updatedTools)).then();
    }

    public Mono<Void> handlePromptListChanged(String name, List<McpSchema.Prompt> updatedPrompts) {
        logger.debug("Handling prompt list changed notification for client {}", (Object)name);
        List<Function<List<McpSchema.Prompt>, Mono<Void>>> consumers = this.promptListChangedHandlers.get(name);
        if (consumers == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(consumers).flatMap(c -> (Publisher)c.apply(updatedPrompts)).then();
    }

    public Mono<Void> handleResourceListChanged(String name, List<McpSchema.Resource> updatedResources) {
        logger.debug("Handling resource list changed notification for client {}", (Object)name);
        List<Function<List<McpSchema.Resource>, Mono<Void>>> consumers = this.resourceListChangedHandlers.get(name);
        if (consumers == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(consumers).flatMap(c -> (Publisher)c.apply(updatedResources)).then();
    }

    public void afterSingletonsInstantiated() {
        Map<Class<? extends Annotation>, Set<Object>> beansByAnnotation = this.getBeansByAnnotationType();
        List<AsyncSamplingSpecification> samplingSpecs = AsyncMcpAnnotationProviders.samplingSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpSampling.class)));
        for (AsyncSamplingSpecification asyncSamplingSpecification : samplingSpecs) {
            for (String client : asyncSamplingSpecification.clients()) {
                logger.debug("Registering sampling handler for {}", (Object)client);
                this.samplingHandlers.put(client, asyncSamplingSpecification.samplingHandler());
            }
        }
        List<AsyncElicitationSpecification> elicitationSpecs = AsyncMcpAnnotationProviders.elicitationSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpElicitation.class)));
        for (AsyncElicitationSpecification asyncElicitationSpecification : elicitationSpecs) {
            for (String client : asyncElicitationSpecification.clients()) {
                logger.debug("Registering elicitation handler for {}", (Object)client);
                this.elicitationHandlers.put(client, asyncElicitationSpecification.elicitationHandler());
            }
        }
        List<AsyncLoggingSpecification> list = AsyncMcpAnnotationProviders.loggingSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpLogging.class)));
        for (AsyncLoggingSpecification loggingSpec : list) {
            for (String client : loggingSpec.clients()) {
                logger.debug("Registering logging handler for {}", (Object)client);
                this.loggingHandlers.computeIfAbsent(client, k -> new ArrayList()).add(loggingSpec.loggingHandler());
            }
        }
        List<AsyncProgressSpecification> list2 = AsyncMcpAnnotationProviders.progressSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpProgress.class)));
        for (AsyncProgressSpecification progressSpec : list2) {
            for (String client : progressSpec.clients()) {
                logger.debug("Registering progress handler for {}", (Object)client);
                this.progressHandlers.computeIfAbsent(client, k -> new ArrayList()).add(progressSpec.progressHandler());
            }
        }
        List<AsyncToolListChangedSpecification> toolsListChangedSpecs = AsyncMcpAnnotationProviders.toolListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpToolListChanged.class)));
        for (AsyncToolListChangedSpecification toolsListChangedSpec : toolsListChangedSpecs) {
            for (String client : toolsListChangedSpec.clients()) {
                logger.debug("Registering tool list changed handler for {}", (Object)client);
                this.toolListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(toolsListChangedSpec.toolListChangeHandler());
            }
        }
        List<AsyncPromptListChangedSpecification> promptListChangedSpecs = AsyncMcpAnnotationProviders.promptListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpPromptListChanged.class)));
        for (AsyncPromptListChangedSpecification promptListChangedSpec : promptListChangedSpecs) {
            for (String client : promptListChangedSpec.clients()) {
                logger.debug("Registering prompt list changed handler for {}", (Object)client);
                this.promptListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(promptListChangedSpec.promptListChangeHandler());
            }
        }
        List<AsyncResourceListChangedSpecification> resourceListChangedSpecs = AsyncMcpAnnotationProviders.resourceListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpResourceListChanged.class)));
        for (AsyncResourceListChangedSpecification resourceListChangedSpec : resourceListChangedSpecs) {
            for (String client : resourceListChangedSpec.clients()) {
                logger.debug("Registering resource list changed handler for {}", (Object)client);
                this.resourceListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(resourceListChangedSpec.resourceListChangeHandler());
            }
        }
    }
}

