/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.EmbeddingsUsage;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AzureOpenAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final OpenAIClient azureOpenAiClient;
    private final AzureOpenAiEmbeddingOptions defaultOptions;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient) {
        this(azureOpenAiClient, MetadataMode.EMBED);
    }

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient, MetadataMode metadataMode) {
        this(azureOpenAiClient, metadataMode, AzureOpenAiEmbeddingOptions.builder().deploymentName("text-embedding-ada-002").build());
    }

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient, MetadataMode metadataMode, AzureOpenAiEmbeddingOptions options) {
        this(azureOpenAiClient, metadataMode, options, ObservationRegistry.NOOP);
    }

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient, MetadataMode metadataMode, AzureOpenAiEmbeddingOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)azureOpenAiClient, (String)"com.azure.ai.openai.OpenAIClient must not be null");
        Assert.notNull((Object)metadataMode, (String)"Metadata mode must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)observationRegistry, (String)"Observation registry must not be null");
        this.azureOpenAiClient = azureOpenAiClient;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        logger.debug("Retrieving embeddings");
        EmbeddingResponse response = this.call(new EmbeddingRequest(List.of(document.getFormattedContent(this.metadataMode)), null));
        logger.debug("Embeddings retrieved");
        if (CollectionUtils.isEmpty((Collection)response.getResults())) {
            return new float[0];
        }
        return ((Embedding)response.getResults().get(0)).getOutput();
    }

    public EmbeddingResponse call(EmbeddingRequest embeddingRequest) {
        logger.debug("Retrieving embeddings");
        AzureOpenAiEmbeddingOptions options = AzureOpenAiEmbeddingOptions.builder().from(this.defaultOptions).merge(embeddingRequest.getOptions()).build();
        EmbeddingRequest embeddingRequestWithMergedOptions = new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)options);
        EmbeddingsOptions azureOptions = options.toAzureOptions(embeddingRequestWithMergedOptions.getInstructions());
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequestWithMergedOptions).provider(AiProvider.AZURE_OPENAI.value()).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            Embeddings embeddings = this.azureOpenAiClient.getEmbeddings(azureOptions.getModel(), azureOptions);
            logger.debug("Embeddings retrieved");
            EmbeddingResponse embeddingResponse = this.generateEmbeddingResponse(embeddings);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    EmbeddingsOptions toEmbeddingOptions(EmbeddingRequest embeddingRequest) {
        return AzureOpenAiEmbeddingOptions.builder().from(this.defaultOptions).merge(embeddingRequest.getOptions()).build().toAzureOptions(embeddingRequest.getInstructions());
    }

    private EmbeddingResponse generateEmbeddingResponse(Embeddings embeddings) {
        List<Embedding> data = this.generateEmbeddingList(embeddings.getData());
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.setUsage((Usage)this.getDefaultUsage(embeddings.getUsage()));
        return new EmbeddingResponse(data, metadata);
    }

    private DefaultUsage getDefaultUsage(EmbeddingsUsage usage) {
        return new DefaultUsage(Integer.valueOf(usage.getPromptTokens()), Integer.valueOf(0), Integer.valueOf(usage.getTotalTokens()), (Object)usage);
    }

    private List<Embedding> generateEmbeddingList(List<EmbeddingItem> nativeData) {
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        for (EmbeddingItem nativeDatum : nativeData) {
            List nativeDatumEmbedding = nativeDatum.getEmbedding();
            int nativeIndex = nativeDatum.getPromptIndex();
            Embedding embedding = new Embedding(EmbeddingUtils.toPrimitive((List)nativeDatumEmbedding), Integer.valueOf(nativeIndex));
            data.add(embedding);
        }
        return data;
    }

    public AzureOpenAiEmbeddingOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

