/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.ChatCompletionStreamOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureOpenAiChatOptions
implements ToolCallingChatOptions {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiChatOptions.class);
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="response_format")
    private AzureOpenAiResponseFormat responseFormat;
    @JsonProperty(value="seed")
    private Long seed;
    @JsonProperty(value="log_probs")
    private Boolean logprobs;
    @JsonProperty(value="top_log_probs")
    private Integer topLogProbs;
    @JsonProperty(value="max_completion_tokens")
    private Integer maxCompletionTokens;
    @JsonIgnore
    private AzureChatEnhancementConfiguration enhancements;
    @JsonProperty(value="stream_options")
    private ChatCompletionStreamOptions streamOptions;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Boolean enableStreamUsage;
    @JsonProperty(value="reasoning_effort")
    private String reasoningEffort;

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AzureOpenAiChatOptions fromOptions(AzureOpenAiChatOptions fromOptions) {
        return AzureOpenAiChatOptions.builder().deploymentName(fromOptions.getDeploymentName()).frequencyPenalty(fromOptions.getFrequencyPenalty() != null ? fromOptions.getFrequencyPenalty() : null).logitBias(fromOptions.getLogitBias()).maxTokens(fromOptions.getMaxTokens()).maxCompletionTokens(fromOptions.getMaxCompletionTokens()).N(fromOptions.getN()).presencePenalty(fromOptions.getPresencePenalty() != null ? fromOptions.getPresencePenalty() : null).stop((List<String>)(fromOptions.getStop() != null ? new ArrayList<String>(fromOptions.getStop()) : null)).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).user(fromOptions.getUser()).toolCallbacks((List<ToolCallback>)(fromOptions.getToolCallbacks() != null ? new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()) : null)).toolNames((Set<String>)(fromOptions.getToolNames() != null ? new HashSet<String>(fromOptions.getToolNames()) : null)).responseFormat(fromOptions.getResponseFormat()).streamUsage(fromOptions.getStreamUsage()).reasoningEffort(fromOptions.getReasoningEffort()).seed(fromOptions.getSeed()).logprobs(fromOptions.isLogprobs()).topLogprobs(fromOptions.getTopLogProbs()).enhancements(fromOptions.getEnhancements()).toolContext((Map<String, Object>)(fromOptions.getToolContext() != null ? new HashMap<String, Object>(fromOptions.getToolContext()) : null)).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).streamOptions(fromOptions.getStreamOptions()).build();
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonIgnore
    public String getModel() {
        return this.getDeploymentName();
    }

    @JsonIgnore
    public void setModel(String model) {
        this.setDeploymentName(model);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setFunctions(Set<String> functions) {
        this.setToolNames(functions);
    }

    public AzureOpenAiResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Boolean getStreamUsage() {
        return this.enableStreamUsage;
    }

    public void setStreamUsage(Boolean enableStreamUsage) {
        this.enableStreamUsage = enableStreamUsage;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public void setReasoningEffort(String reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Boolean isLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogProbs() {
        return this.topLogProbs;
    }

    public void setTopLogProbs(Integer topLogProbs) {
        this.topLogProbs = topLogProbs;
    }

    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    public void setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public ChatCompletionStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(ChatCompletionStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public AzureOpenAiChatOptions copy() {
        return AzureOpenAiChatOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AzureOpenAiChatOptions)) {
            return false;
        }
        AzureOpenAiChatOptions that = (AzureOpenAiChatOptions)o;
        return Objects.equals(this.logitBias, that.logitBias) && Objects.equals(this.user, that.user) && Objects.equals(this.n, that.n) && Objects.equals(this.stop, that.stop) && Objects.equals(this.deploymentName, that.deploymentName) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.logprobs, that.logprobs) && Objects.equals(this.topLogProbs, that.topLogProbs) && Objects.equals(this.enhancements, that.enhancements) && Objects.equals(this.streamOptions, that.streamOptions) && Objects.equals(this.enableStreamUsage, that.enableStreamUsage) && Objects.equals(this.reasoningEffort, that.reasoningEffort) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.maxCompletionTokens, that.maxCompletionTokens) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP);
    }

    public int hashCode() {
        return Objects.hash(this.logitBias, this.user, this.n, this.stop, this.deploymentName, this.responseFormat, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.seed, this.logprobs, this.topLogProbs, this.enhancements, this.streamOptions, this.reasoningEffort, this.enableStreamUsage, this.toolContext, this.maxTokens, this.maxCompletionTokens, this.frequencyPenalty, this.presencePenalty, this.temperature, this.topP);
    }

    public static final class Builder {
        protected AzureOpenAiChatOptions options;

        public Builder() {
            this.options = new AzureOpenAiChatOptions();
        }

        public Builder(AzureOpenAiChatOptions options) {
            this.options = options;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.deploymentName = deploymentName;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            if (maxTokens != null && this.options.maxCompletionTokens != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. Azure OpenAI API does not support setting both parameters simultaneously. The previously set maxCompletionTokens ({}) will be cleared and maxTokens ({}) will be used.", (Object)this.options.maxCompletionTokens, (Object)maxTokens);
                this.options.maxCompletionTokens = null;
            }
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            if (maxCompletionTokens != null && this.options.maxTokens != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. Azure OpenAI API does not support setting both parameters simultaneously. The previously set maxTokens ({}) will be cleared and maxCompletionTokens ({}) will be used.", (Object)this.options.maxTokens, (Object)maxCompletionTokens);
                this.options.maxTokens = null;
            }
            this.options.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder responseFormat(AzureOpenAiResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder streamUsage(Boolean enableStreamUsage) {
            this.options.enableStreamUsage = enableStreamUsage;
            return this;
        }

        public Builder reasoningEffort(String reasoningEffort) {
            this.options.reasoningEffort = reasoningEffort;
            return this;
        }

        public Builder seed(Long seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogProbs = topLogprobs;
            return this;
        }

        public Builder enhancements(AzureChatEnhancementConfiguration enhancements) {
            this.options.enhancements = enhancements;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder streamOptions(ChatCompletionStreamOptions streamOptions) {
            this.options.streamOptions = streamOptions;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public AzureOpenAiChatOptions build() {
            return this.options;
        }
    }
}

