/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerationQuality;
import com.azure.ai.openai.models.ImageGenerationResponseFormat;
import com.azure.ai.openai.models.ImageGenerationStyle;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.ImageSize;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.azure.openai.AzureOpenAiImageOptions;
import org.springframework.ai.azure.openai.metadata.AzureOpenAiImageGenerationMetadata;
import org.springframework.ai.azure.openai.metadata.AzureOpenAiImageResponseMetadata;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageGenerationMetadata;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.util.Assert;

public class AzureOpenAiImageModel
implements ImageModel {
    private static final String DEFAULT_DEPLOYMENT_NAME = AzureOpenAiImageOptions.DEFAULT_IMAGE_MODEL;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenAIClient openAIClient;
    private final AzureOpenAiImageOptions defaultOptions;
    private final ObjectMapper objectMapper;

    public AzureOpenAiImageModel(OpenAIClient openAIClient) {
        this(openAIClient, AzureOpenAiImageOptions.builder().deploymentName(DEFAULT_DEPLOYMENT_NAME).build());
    }

    public AzureOpenAiImageModel(OpenAIClient microsoftOpenAiClient, AzureOpenAiImageOptions options) {
        Assert.notNull((Object)microsoftOpenAiClient, (String)"com.azure.ai.openai.OpenAIClient must not be null");
        Assert.notNull((Object)options, (String)"AzureOpenAiChatOptions must not be null");
        this.openAIClient = microsoftOpenAiClient;
        this.defaultOptions = options;
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).build();
    }

    public AzureOpenAiImageOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        ImageGenerationOptions imageGenerationOptions = this.toOpenAiImageOptions(imagePrompt);
        String deploymentOrModelName = this.getDeploymentName(imagePrompt);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Azure ImageGenerationOptions call {} with the following options : {} ", (Object)deploymentOrModelName, (Object)this.toPrettyJson(imageGenerationOptions));
        }
        ImageGenerations images = this.openAIClient.getImageGenerations(deploymentOrModelName, imageGenerationOptions);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Azure ImageGenerations: {}", (Object)this.toPrettyJson(images));
        }
        List<ImageGeneration> imageGenerations = images.getData().stream().map(entry -> {
            Image image = new Image(entry.getUrl(), entry.getBase64Data());
            AzureOpenAiImageGenerationMetadata metadata = new AzureOpenAiImageGenerationMetadata(entry.getRevisedPrompt());
            return new ImageGeneration(image, (ImageGenerationMetadata)metadata);
        }).toList();
        AzureOpenAiImageResponseMetadata openAiImageResponseMetadata = AzureOpenAiImageResponseMetadata.from(images);
        return new ImageResponse(imageGenerations, (ImageResponseMetadata)openAiImageResponseMetadata);
    }

    private String toPrettyJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return "JsonProcessingException:" + String.valueOf((Object)e) + " [" + object.toString() + "]";
        }
    }

    private String getDeploymentName(ImagePrompt prompt) {
        AzureOpenAiImageOptions runtimeAzureOpenAiImageOptions;
        ImageOptions runtimeImageOptions = prompt.getOptions();
        if (this.defaultOptions != null) {
            runtimeImageOptions = (ImageOptions)ModelOptionsUtils.merge((Object)runtimeImageOptions, (Object)this.defaultOptions, AzureOpenAiImageOptions.class);
        }
        if (runtimeImageOptions != null && runtimeImageOptions instanceof AzureOpenAiImageOptions && (runtimeAzureOpenAiImageOptions = (AzureOpenAiImageOptions)runtimeImageOptions).getDeploymentName() != null) {
            return runtimeAzureOpenAiImageOptions.getDeploymentName();
        }
        return prompt.getOptions().getModel();
    }

    private ImageGenerationOptions toOpenAiImageOptions(ImagePrompt prompt) {
        if (prompt.getInstructions().size() > 1) {
            throw new RuntimeException(String.format("implementation support 1 image instruction only, found %s", prompt.getInstructions().size()));
        }
        if (prompt.getInstructions().isEmpty()) {
            throw new RuntimeException("please provide image instruction, current is empty");
        }
        String instructions = ((ImageMessage)prompt.getInstructions().get(0)).getText();
        ImageOptions runtimeImageOptions = prompt.getOptions();
        ImageGenerationOptions imageGenerationOptions = new ImageGenerationOptions(instructions);
        if (this.defaultOptions != null) {
            runtimeImageOptions = (ImageOptions)ModelOptionsUtils.merge((Object)runtimeImageOptions, (Object)this.defaultOptions, AzureOpenAiImageOptions.class);
        }
        if (runtimeImageOptions != null) {
            if (runtimeImageOptions.getN() != null) {
                imageGenerationOptions.setN(runtimeImageOptions.getN());
            }
            if (runtimeImageOptions.getModel() != null) {
                imageGenerationOptions.setModel(runtimeImageOptions.getModel());
            }
            if (runtimeImageOptions.getResponseFormat() != null) {
                imageGenerationOptions.setResponseFormat(ImageGenerationResponseFormat.fromString((String)runtimeImageOptions.getResponseFormat()));
            }
            if (runtimeImageOptions.getWidth() != null && runtimeImageOptions.getHeight() != null) {
                imageGenerationOptions.setSize(ImageSize.fromString((String)(runtimeImageOptions.getWidth() + "x" + runtimeImageOptions.getHeight())));
            }
            if (runtimeImageOptions instanceof AzureOpenAiImageOptions) {
                AzureOpenAiImageOptions runtimeAzureOpenAiImageOptions = (AzureOpenAiImageOptions)runtimeImageOptions;
                if (runtimeAzureOpenAiImageOptions.getQuality() != null) {
                    imageGenerationOptions.setQuality(ImageGenerationQuality.fromString((String)runtimeAzureOpenAiImageOptions.getQuality()));
                }
                if (runtimeAzureOpenAiImageOptions.getStyle() != null) {
                    imageGenerationOptions.setStyle(ImageGenerationStyle.fromString((String)runtimeAzureOpenAiImageOptions.getStyle()));
                }
                if (runtimeAzureOpenAiImageOptions.getUser() != null) {
                    imageGenerationOptions.setUser(runtimeAzureOpenAiImageOptions.getUser());
                }
            }
        }
        return imageGenerationOptions;
    }
}

