/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.properties;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.mcp.server.streamable-http")
public class McpServerStreamableHttpProperties {
    public static final String CONFIG_PREFIX = "spring.ai.mcp.server.streamable-http";
    private String mcpEndpoint = "/mcp";
    private Duration keepAliveInterval;
    private boolean disallowDelete;

    public String getMcpEndpoint() {
        return this.mcpEndpoint;
    }

    public void setMcpEndpoint(String mcpEndpoint) {
        Assert.hasText((String)mcpEndpoint, (String)"MCP endpoint must not be empty");
        this.mcpEndpoint = mcpEndpoint;
    }

    public void setKeepAliveInterval(Duration keepAliveInterval) {
        Assert.notNull((Object)keepAliveInterval, (String)"Keep-alive interval must not be null");
        this.keepAliveInterval = keepAliveInterval;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public boolean isDisallowDelete() {
        return this.disallowDelete;
    }

    public void setDisallowDelete(boolean disallowDelete) {
        this.disallowDelete = disallowDelete;
    }
}

