/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.fasterxml.jackson.databind.Module;
import java.util.Optional;
import org.springdoc.core.data.SpringDocJackson2HalModule;
import org.springdoc.core.providers.HateoasHalProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.hateoas.autoconfigure.HateoasProperties;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;

public class DataRestHalProvider
extends HateoasHalProvider
implements InitializingBean {
    private final Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional;

    public DataRestHalProvider(Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional, Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        super(hateoasPropertiesOptional, objectMapperProvider);
        this.repositoryRestConfigurationOptional = repositoryRestConfigurationOptional;
    }

    @Override
    public void afterPropertiesSet() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!SpringDocJackson2HalModule.isAlreadyRegisteredIn(this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new SpringDocJackson2HalModule());
        }
    }

    @Override
    public boolean isHalEnabled() {
        return this.repositoryRestConfigurationOptional.map(RepositoryRestConfiguration::useHalAsDefaultJsonMediaType).orElse(true);
    }
}

