/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.launch.constant.TokenConstant;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.TokenInfo;
import org.springblade.core.secure.exception.SecureException;
import org.springblade.core.secure.props.BladeTokenProperties;
import org.springblade.core.secure.provider.IClientDetails;
import org.springblade.core.secure.provider.IClientDetailsService;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;

public class SecureUtil {
    private static final String BLADE_USER_REQUEST_ATTR = "_BLADE_USER_REQUEST_ATTR_";
    private static final String HEADER = "blade-auth";
    private static final String BEARER = "bearer";
    private static final String ACCOUNT = "account";
    private static final String USER_ID = "user_id";
    private static final String ROLE_ID = "role_id";
    private static final String DEPT_ID = "dept_id";
    private static final String USER_NAME = "user_name";
    private static final String ROLE_NAME = "role_name";
    private static final String TENANT_ID = "tenant_id";
    private static final String CLIENT_ID = "client_id";
    private static final Integer AUTH_LENGTH = TokenConstant.AUTH_LENGTH;
    private static IClientDetailsService CLIENT_DETAILS_SERVICE;
    private static BladeTokenProperties TOKEN_PROPERTIES;
    private static String BASE64_SECURITY;

    private static IClientDetailsService getClientDetailsService() {
        if (CLIENT_DETAILS_SERVICE == null) {
            CLIENT_DETAILS_SERVICE = (IClientDetailsService)SpringUtil.getBean(IClientDetailsService.class);
        }
        return CLIENT_DETAILS_SERVICE;
    }

    private static BladeTokenProperties getTokenProperties() {
        if (TOKEN_PROPERTIES == null) {
            TOKEN_PROPERTIES = (BladeTokenProperties)SpringUtil.getBean(BladeTokenProperties.class);
        }
        return TOKEN_PROPERTIES;
    }

    private static String getBase64Security() {
        if (BASE64_SECURITY == null) {
            BASE64_SECURITY = Base64.getEncoder().encodeToString(SecureUtil.getTokenProperties().getSignKey().getBytes(Charsets.UTF_8));
        }
        return BASE64_SECURITY;
    }

    public static BladeUser getUser() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        Object bladeUser = request.getAttribute(BLADE_USER_REQUEST_ATTR);
        if (bladeUser == null && (bladeUser = SecureUtil.getUser(request)) != null) {
            request.setAttribute(BLADE_USER_REQUEST_ATTR, bladeUser);
        }
        return (BladeUser)bladeUser;
    }

    public static BladeUser getUser(HttpServletRequest request) {
        Claims claims = SecureUtil.getClaims(request);
        if (claims == null) {
            return null;
        }
        String clientId = Func.toStr((Object)claims.get((Object)CLIENT_ID));
        Long userId = Func.toLong((Object)claims.get((Object)USER_ID));
        String tenantId = Func.toStr((Object)claims.get((Object)TENANT_ID));
        String roleId = Func.toStr((Object)claims.get((Object)ROLE_ID));
        String deptId = Func.toStr((Object)claims.get((Object)DEPT_ID));
        String account = Func.toStr((Object)claims.get((Object)ACCOUNT));
        String roleName = Func.toStr((Object)claims.get((Object)ROLE_NAME));
        String userName = Func.toStr((Object)claims.get((Object)USER_NAME));
        BladeUser bladeUser = new BladeUser();
        bladeUser.setClientId(clientId);
        bladeUser.setUserId(userId);
        bladeUser.setTenantId(tenantId);
        bladeUser.setAccount(account);
        bladeUser.setRoleId(roleId);
        bladeUser.setDeptId(deptId);
        bladeUser.setRoleName(roleName);
        bladeUser.setUserName(userName);
        return bladeUser;
    }

    public static boolean isAdministrator() {
        return StringUtil.containsAny((CharSequence)SecureUtil.getUserRole(), (CharSequence[])new CharSequence[]{"administrator"});
    }

    public static Long getUserId() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? -1L : user.getUserId();
    }

    public static Long getUserId(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? -1L : user.getUserId();
    }

    public static String getUserAccount() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? "" : user.getAccount();
    }

    public static String getUserAccount(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? "" : user.getAccount();
    }

    public static String getUserName() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? "" : user.getUserName();
    }

    public static String getUserName(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? "" : user.getUserName();
    }

    public static String getUserRole() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? "" : user.getRoleName();
    }

    public static String getUserRole(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? "" : user.getRoleName();
    }

    public static String getTenantId() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? "" : user.getTenantId();
    }

    public static String getTenantId(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? "" : user.getTenantId();
    }

    public static String getClientId() {
        BladeUser user = SecureUtil.getUser();
        return null == user ? "" : user.getClientId();
    }

    public static String getClientId(HttpServletRequest request) {
        BladeUser user = SecureUtil.getUser(request);
        return null == user ? "" : user.getClientId();
    }

    public static Claims getClaims(HttpServletRequest request) {
        String auth = request.getHeader(HEADER);
        if (StringUtil.isNotBlank((CharSequence)auth) && auth.length() > AUTH_LENGTH) {
            String headStr = auth.substring(0, 6).toLowerCase();
            if (headStr.compareTo(BEARER) == 0) {
                auth = auth.substring(7);
                return SecureUtil.parseJWT(auth);
            }
        } else {
            String parameter = request.getParameter(HEADER);
            if (StringUtil.isNotBlank((CharSequence)parameter)) {
                return SecureUtil.parseJWT(parameter);
            }
        }
        return null;
    }

    public static String getHeader() {
        return SecureUtil.getHeader(Objects.requireNonNull(WebUtil.getRequest()));
    }

    public static String getHeader(HttpServletRequest request) {
        return request.getHeader(HEADER);
    }

    public static Claims parseJWT(String jsonWebToken) {
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(Base64.getDecoder().decode(SecureUtil.getBase64Security())).build().parseClaimsJws(jsonWebToken).getBody();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static TokenInfo createJWT(Map<String, String> user, String audience, String issuer, String tokenType) {
        String[] tokens = SecureUtil.extractAndDecodeHeader();
        assert (tokens.length == 2);
        String clientId = tokens[0];
        String clientSecret = tokens[1];
        IClientDetails clientDetails = SecureUtil.clientDetails(clientId);
        if (!SecureUtil.validateClient(clientDetails, clientId, clientSecret)) {
            throw new SecureException("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25!");
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = Base64.getDecoder().decode(SecureUtil.getBase64Security());
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setIssuer(issuer).setAudience(audience).signWith((Key)signingKey);
        user.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
        builder.claim(CLIENT_ID, (Object)clientId);
        long expireMillis = tokenType.equals("access_token") ? (long)(clientDetails.getAccessTokenValidity() * 1000) : (tokenType.equals("refresh_token") ? (long)(clientDetails.getRefreshTokenValidity() * 1000) : SecureUtil.getExpire());
        long expMillis = nowMillis + expireMillis;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp).setNotBefore(now);
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setToken(builder.compact());
        tokenInfo.setExpire((int)expireMillis / 1000);
        return tokenInfo;
    }

    public static long getExpire() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 3);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    public static String[] extractAndDecodeHeader() {
        byte[] decoded;
        String header = Objects.requireNonNull(WebUtil.getRequest()).getHeader("Authorization");
        header = Func.toStr((Object)header).replace("Basic%20", "Basic ");
        if (!header.startsWith("Basic ")) {
            throw new SecureException("No client information in request header");
        }
        byte[] base64Token = header.substring(6).getBytes(Charsets.UTF_8_NAME);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException var7) {
            throw new RuntimeException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, Charsets.UTF_8_NAME);
        int index = token.indexOf(":");
        if (index == -1) {
            throw new RuntimeException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, index), token.substring(index + 1)};
    }

    public static String getClientIdFromHeader() {
        String[] tokens = SecureUtil.extractAndDecodeHeader();
        assert (tokens.length == 2);
        return tokens[0];
    }

    private static IClientDetails clientDetails(String clientId) {
        return SecureUtil.getClientDetailsService().loadClientByClientId(clientId);
    }

    private static boolean validateClient(IClientDetails clientDetails, String clientId, String clientSecret) {
        if (clientDetails != null) {
            return StringUtil.equals((CharSequence)clientId, (CharSequence)clientDetails.getClientId()) && StringUtil.equals((CharSequence)clientSecret, (CharSequence)clientDetails.getClientSecret());
        }
        return false;
    }
}

