/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.oauth2.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springaicommunity.mcp.security.server.oauth2.metadata.ResourceIdentifier;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public final class BearerResourceMetadataTokenAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final AuthenticationEntryPoint delegate = new BearerTokenAuthenticationEntryPoint();
    private final ResourceIdentifier resourceIdentifier;

    public BearerResourceMetadataTokenAuthenticationEntryPoint(ResourceIdentifier resourceIdentifier) {
        Assert.notNull((Object)resourceIdentifier, (String)"resourceIdentifier cannot be null");
        this.resourceIdentifier = resourceIdentifier;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.delegate.commence(request, response, authException);
        Object wwwAuthenticateHeader = response.getHeader("WWW-Authenticate");
        wwwAuthenticateHeader = "bearer".equalsIgnoreCase((String)wwwAuthenticateHeader) ? (String)wwwAuthenticateHeader + " " : (String)wwwAuthenticateHeader + ", ";
        wwwAuthenticateHeader = (String)wwwAuthenticateHeader + "resource_metadata=" + this.buildResourceMetadataPath(request, this.resourceIdentifier);
        response.setHeader("WWW-Authenticate", (String)wwwAuthenticateHeader);
    }

    private String buildResourceMetadataPath(HttpServletRequest request, ResourceIdentifier resourceIdentifier) {
        return UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath("/.well-known/oauth-protected-resource" + resourceIdentifier.getPath()).replaceQuery(null).fragment(null).toUriString();
    }
}

