/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.prompt;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.springaicommunity.mcp.method.changed.prompt.AbstractMcpPromptListChangedMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncMcpPromptListChangedMethodCallback
extends AbstractMcpPromptListChangedMethodCallback
implements Function<List<McpSchema.Prompt>, Mono<Void>> {
    private AsyncMcpPromptListChangedMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public Mono<Void> apply(List<McpSchema.Prompt> updatedPrompts) {
        if (updatedPrompts == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Updated prompts list must not be null"));
        }
        try {
            Object[] args = this.buildArgs(this.method, null, updatedPrompts);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            if (result instanceof Mono) {
                Mono monoResult = (Mono)result;
                return monoResult.flatMap(value -> {
                    if (value != null) {
                        throw new ClassCastException("Expected Mono<Void> but got Mono<" + value.getClass().getName() + ">");
                    }
                    return Mono.empty();
                }).then();
            }
            return Mono.empty();
        }
        catch (Exception e) {
            return Mono.error((Throwable)new AbstractMcpPromptListChangedMethodCallback.McpPromptListChangedConsumerMethodException("Error invoking prompt list changed consumer method: " + this.method.getName(), e));
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && !Mono.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must have void or Mono<Void> return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpPromptListChangedMethodCallback.AbstractBuilder<Builder, AsyncMcpPromptListChangedMethodCallback> {
        @Override
        public AsyncMcpPromptListChangedMethodCallback build() {
            this.validate();
            return new AsyncMcpPromptListChangedMethodCallback(this);
        }
    }
}

