/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.EnableSharedInjection;
import org.spockframework.spring.SpringExtensionException;
import org.spockframework.spring.SpringInterceptor;
import org.spockframework.spring.SpringTestContextManager;
import org.spockframework.util.ReflectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.ContextConfiguration;
import spock.lang.Shared;

public class SpringExtension
implements IGlobalExtension {
    private static final Class<? extends Annotation> contextHierarchyClass = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.test.context.ContextHierarchy");
    private static final Method findAnnotationDescriptorForTypesMethod;
    private static final Class<? extends Annotation> bootstrapWithAnnotation;

    public void visitSpec(SpecInfo spec) {
        if (!this.isSpringSpec(spec)) {
            return;
        }
        this.verifySharedFieldsInjection(spec);
        if (!this.handleProfileValues(spec)) {
            return;
        }
        SpringTestContextManager manager = new SpringTestContextManager((Class)spec.getReflection());
        final SpringInterceptor interceptor = new SpringInterceptor(manager);
        spec.addListener((IRunListener)new AbstractRunListener(){

            public void error(ErrorInfo error) {
                interceptor.error(error);
            }
        });
        spec.addSetupSpecInterceptor((IMethodInterceptor)interceptor);
        spec.addInitializerInterceptor((IMethodInterceptor)interceptor);
        spec.addSetupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
    }

    private boolean isSpringSpec(SpecInfo spec) {
        if (this.isSpringSpecUsingFindAnnotationDescriptorForTypes(spec)) {
            return true;
        }
        if (ReflectionUtil.isAnnotationPresentRecursive((Class)((Class)spec.getReflection()), ContextConfiguration.class)) {
            return true;
        }
        return contextHierarchyClass != null && ReflectionUtil.isAnnotationPresentRecursive((Class)((Class)spec.getReflection()), contextHierarchyClass);
    }

    private boolean isSpringSpecUsingFindAnnotationDescriptorForTypes(SpecInfo spec) {
        return findAnnotationDescriptorForTypesMethod != null && ReflectionUtil.invokeMethod(null, (Method)findAnnotationDescriptorForTypesMethod, (Object[])new Object[]{spec.getReflection(), new Class[]{ContextConfiguration.class, contextHierarchyClass, bootstrapWithAnnotation}}) != null;
    }

    private void verifySharedFieldsInjection(SpecInfo spec) {
        if (spec.isAnnotationPresent(EnableSharedInjection.class)) {
            this.verifySharedFieldsInjectionEnabled(spec);
        } else {
            this.checkNoSharedFieldsInjected(spec);
        }
    }

    private void verifySharedFieldsInjectionEnabled(SpecInfo spec) {
        DirtiesContext.ClassMode classMode;
        if (spec.isAnnotationPresent(DirtiesContext.class) && ((classMode = ((DirtiesContext)spec.getAnnotation(DirtiesContext.class)).classMode()) == DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD || classMode == DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)) {
            throw this.sharedInjectionWithDirtiesContextException();
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            MethodInfo featureMethod = feature.getFeatureMethod();
            if (!featureMethod.isAnnotationPresent(DirtiesContext.class)) continue;
            throw this.sharedInjectionWithDirtiesContextException();
        }
    }

    private SpringExtensionException sharedInjectionWithDirtiesContextException() {
        return new SpringExtensionException("Shared field injection is not supported if feature methods make context dirty by using @DirtiesContext annotation");
    }

    private void checkNoSharedFieldsInjected(SpecInfo spec) {
        for (FieldInfo field : spec.getAllFields()) {
            if (!((Field)field.getReflection()).isAnnotationPresent(Shared.class) || !((Field)field.getReflection()).isAnnotationPresent(Autowired.class) && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)field.getReflection(), (String)"javax.annotation.Resource") && !ReflectionUtil.isAnnotationPresent((AnnotatedElement)field.getReflection(), (String)"javax.inject.Inject")) continue;
            throw new SpringExtensionException("@Shared field injection is not enabled by default therefore '%s' field cannot be injected. Refer to javadoc of %s for information on how to opt-in for @Shared field injection.").withArgs(new Object[]{field.getName(), EnableSharedInjection.class.getName()});
        }
    }

    private boolean handleProfileValues(SpecInfo spec) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)((Class)spec.getReflection()))) {
            spec.setExcluded(true);
            return false;
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (ProfileValueUtils.isTestEnabledInThisEnvironment((Method)((Method)feature.getFeatureMethod().getReflection()), (Class)((Class)spec.getReflection()))) continue;
            feature.setExcluded(true);
        }
        return true;
    }

    static {
        bootstrapWithAnnotation = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.test.context.BootstrapWith");
        Class metaAnnotationUtilsClass = ReflectionUtil.loadClassIfAvailable((String)"org.springframework.test.util.MetaAnnotationUtils");
        findAnnotationDescriptorForTypesMethod = metaAnnotationUtilsClass == null ? null : ReflectionUtil.getMethodBySignature((Class)metaAnnotationUtilsClass, (String)"findAnnotationDescriptorForTypes", (Class[])new Class[]{Class.class, Class[].class});
    }
}

