/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.spiffyui.build.RevisionInfoBean;

public class RevisionInfoUtil {
    public static RevisionInfoBean getRevisionInfo(File rootDir) throws InterruptedException {
        try {
            RevisionInfoBean revInfo = RevisionInfoUtil.getSubversionRev(rootDir);
            if (revInfo == null) {
                revInfo = RevisionInfoUtil.getGitRev(rootDir);
            }
            if (revInfo == null) {
                return new RevisionInfoBean("-1", "-1");
            }
            return revInfo;
        }
        catch (IOException ioe) {
            return new RevisionInfoBean("-1", "-1");
        }
    }

    private static RevisionInfoBean getSubversionRev(File rootDir) throws InterruptedException, IOException {
        Process proc = Runtime.getRuntime().exec("svn info " + rootDir.getAbsolutePath());
        InputStream is = proc.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        ProcessWatcher pw = new ProcessWatcher(proc);
        while (!pw.isFinished()) {
            String line;
            int exit = -1;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("Revision: ")) {
                    return new RevisionInfoBean(line.substring(10, line.length()), "-1");
                }
                try {
                    exit = proc.exitValue();
                    if (exit != 0) continue;
                }
                catch (IllegalThreadStateException t) {}
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private static RevisionInfoBean getGitRev(File rootDir) throws InterruptedException, IOException {
        String[] args = new String[]{"git", "log", "--pretty=Revision: %h:%ct0000", "-n1", "HEAD", rootDir.getAbsolutePath()};
        Process proc = Runtime.getRuntime().exec(args);
        InputStream is = proc.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        ProcessWatcher pw = new ProcessWatcher(proc);
        while (!pw.isFinished()) {
            String line;
            int exit = -1;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("Revision: ")) {
                    int colIndex = line.indexOf(58, 11);
                    return new RevisionInfoBean(line.substring(10, colIndex), line.substring(colIndex + 1, line.length() - 1));
                }
                try {
                    exit = proc.exitValue();
                    if (exit != 0) continue;
                }
                catch (IllegalThreadStateException t) {}
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private static class ProcessWatcher
    implements Runnable {
        private Process m_p;
        private boolean m_finished = false;

        public ProcessWatcher(Process p) {
            this.m_p = p;
            new Thread(this).start();
        }

        public boolean isFinished() {
            return this.m_finished;
        }

        public void run() {
            try {
                this.m_p.waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_finished = true;
        }
    }
}

