/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTMLPropertiesUtil {
    private static final String START = "import com.google.gwt.i18n.client.Messages;\n\n/**\n * This is a generated localized message bundle for accessing HTML string\n *\n */\npublic interface ";

    private HTMLPropertiesUtil() {
    }

    private static Locale findLocale(String name) {
        if (name == null || name.length() < 4) {
            return null;
        }
        name = name.substring(0, name.lastIndexOf(46));
        String country = null;
        String language = null;
        if (name.length() > 7 && (name.charAt(name.length() - 6) == '-' || name.charAt(name.length() - 6) == '_')) {
            language = name.substring(name.length() - 5, name.length() - 3);
        }
        if (name.length() > 4 && (name.charAt(name.length() - 3) == '-' || name.charAt(name.length() - 3) == '_')) {
            if (language == null) {
                language = name.substring(name.length() - 2, name.length());
            } else {
                country = name.substring(name.length() - 2, name.length());
            }
        }
        if (language == null && country == null) {
            return null;
        }
        if (country == null) {
            return new Locale(language);
        }
        return new Locale(language, country);
    }

    private static Properties getProperties(Locale locale, HashMap<String, Properties> props) {
        String key = null;
        key = locale == null ? "" : "_" + locale.toString();
        if (!props.containsKey(key)) {
            props.put(key, new Properties());
        }
        return props.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePropertiesFiles(List<File> files, File destinationFile, String packageName) throws IOException {
        if (destinationFile == null) {
            throw new IllegalArgumentException("Must specify a Properties file destination");
        }
        if (files == null || files.size() == 0) {
            return;
        }
        HashMap<String, Properties> props = new HashMap<String, Properties>();
        ArrayList<String> methods = new ArrayList<String>();
        for (File f : files) {
            Reader in = null;
            try {
                in = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                StringBuffer sb = new StringBuffer();
                int c = -1;
                while ((c = in.read()) > -1) {
                    if (c == 39) {
                        sb.append("&#39;");
                        continue;
                    }
                    if (c == 123 || c == 125) {
                        sb.append('\'');
                        sb.append((char)c);
                        sb.append('\'');
                        continue;
                    }
                    sb.append((char)c);
                }
                Locale loc = HTMLPropertiesUtil.findLocale(f.getName());
                String name = f.getName();
                if (loc != null) {
                    name = name.substring(0, name.lastIndexOf(46) - loc.toString().length() - 1) + name.substring(name.lastIndexOf(46), name.length());
                }
                if (!methods.contains(name)) {
                    methods.add(name);
                }
                HTMLPropertiesUtil.getProperties(loc, props).setProperty(name.replace(' ', '_').replace('.', '_'), sb.toString());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (packageName == null) continue;
            File javaFile = new File(destinationFile.getParentFile(), destinationFile.getName().substring(0, destinationFile.getName().lastIndexOf(46)) + ".java");
            HTMLPropertiesUtil.generateJavaFile(methods, javaFile, packageName);
        }
        for (String loc : props.keySet()) {
            PrintWriter out = null;
            try {
                String name = destinationFile.getName();
                name = name.substring(0, name.lastIndexOf(46)) + loc + name.substring(name.lastIndexOf(46), name.length());
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(destinationFile.getParentFile(), name)), "UTF-8"));
                props.get(loc).store(out, "");
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEmptyPropertiesFiles(List<File> files, File destinationFile, String packageName) throws IOException {
        String name;
        if (destinationFile == null) {
            throw new IllegalArgumentException("Must specify a Properties file destination");
        }
        if (files == null || files.size() == 0) {
            return;
        }
        HashMap<String, Properties> props = new HashMap<String, Properties>();
        ArrayList<String> methods = new ArrayList<String>();
        for (File f : files) {
            Locale loc = HTMLPropertiesUtil.findLocale(f.getName());
            name = f.getName();
            if (loc != null) {
                name = name.substring(0, name.lastIndexOf(46) - loc.toString().length() - 1) + name.substring(name.lastIndexOf(46), name.length());
            }
            if (!methods.contains(name)) {
                methods.add(name);
            }
            HTMLPropertiesUtil.getProperties(loc, props).setProperty(name.replace(' ', '_').replace('.', '_'), " ");
            if (packageName == null) continue;
            File javaFile = new File(destinationFile.getParentFile(), destinationFile.getName().substring(0, destinationFile.getName().lastIndexOf(46)) + ".java");
            HTMLPropertiesUtil.generateJavaFile(methods, javaFile, packageName);
        }
        for (String loc : props.keySet()) {
            PrintWriter out = null;
            try {
                name = destinationFile.getName();
                name = name.substring(0, name.lastIndexOf(46)) + loc + name.substring(name.lastIndexOf(46), name.length());
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(destinationFile.getParentFile(), name)), "UTF-8"));
                props.get(loc).store(out, "");
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateJavaFile(List<String> methods, File destinationFile, String packageName) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile), "UTF-8"));
            out.write("package " + packageName + ";\n\n");
            out.write(START);
            out.write(destinationFile.getName().substring(0, destinationFile.getName().lastIndexOf(46)));
            out.write(" extends Messages {\n");
            for (String m : methods) {
                out.write("    public String " + m.replace('.', '_') + "();\n");
            }
            out.write("}\n");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

