/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.FileUtils;
import org.spiffyui.build.HTMLPropertiesUtil;

public class HTMLPropertiesTask
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File m_destinationFile;
    private String m_packageName;
    private ResourceCollection m_rc;

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void addFilelist(FileList list) {
        this.add((ResourceCollection)list);
    }

    public void setProperties(File file) {
        this.m_destinationFile = file;
    }

    public void setPackage(String packageName) {
        this.m_packageName = packageName;
    }

    public synchronized void add(ResourceCollection c) {
        if (this.m_rc == null) {
            this.m_rc = c;
            return;
        }
        if (!(this.m_rc instanceof Resources)) {
            Resources newRc = new Resources();
            newRc.setProject(this.getProject());
            newRc.add(this.m_rc);
            this.m_rc = newRc;
        }
        ((Resources)this.m_rc).add(c);
    }

    private ResourceCollection getResources() {
        if (this.m_rc == null) {
            return null;
        }
        Restrict noexistRc = new Restrict();
        noexistRc.add(NOT_EXISTS);
        noexistRc.add(this.m_rc);
        Iterator i = noexistRc.iterator();
        while (i.hasNext()) {
            this.log(i.next() + " does not exist.", 0);
        }
        if (this.m_destinationFile != null) {
            for (Object o : this.m_rc) {
                File f;
                if (!(o instanceof FileResource) || !FILE_UTILS.fileNameEquals(f = ((FileResource)o).getFile(), this.m_destinationFile)) continue;
                throw new BuildException("Input file \"" + f + "\" is the same as the output file.");
            }
        }
        Restrict result = new Restrict();
        result.add(EXISTS);
        result.add(this.m_rc);
        return result;
    }

    public void reset() {
        this.m_rc = null;
        this.m_destinationFile = null;
    }

    public void execute() throws BuildException {
        if (this.m_destinationFile == null) {
            throw new BuildException("Must specify a Properties file output");
        }
        if (this.getResources() == null) {
            return;
        }
        try {
            ArrayList<File> files = new ArrayList<File>();
            ResourceCollection rc = this.getResources();
            Iterator i = rc.iterator();
            while (i.hasNext()) {
                files.add(((FileResource)i.next()).getFile());
            }
            HTMLPropertiesUtil.generatePropertiesFiles(files, this.m_destinationFile, this.m_packageName);
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to generate HTML properties", (Throwable)ioe);
        }
    }
}

