/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.FileUtils;

public class ClosureTask
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File m_destinationFile;
    private String m_compilationLevel;
    private ResourceCollection m_rc;
    private File m_closureJar;
    private String m_summaryDetail = "1";
    private String m_warningLevel = "DEFAULT";

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void addFilelist(FileList list) {
        this.add((ResourceCollection)list);
    }

    public void setJSfile(File jsFile) {
        this.m_destinationFile = jsFile;
    }

    public void setClosureJar(File jarFile) {
        this.m_closureJar = jarFile;
    }

    public void setSummaryLevel(String level) {
        this.m_summaryDetail = level;
    }

    public void setWarningLevel(String level) {
        if (!("QUIET".equals(level) || "VERBOSE".equals(level) || "DEFAULT".equals(level))) {
            throw new BuildException("Warning level must be either QUIET, VERBOSE, or DEFAULT");
        }
        this.m_warningLevel = level;
    }

    public void setCompilationLevel(String level) {
        this.m_compilationLevel = level;
    }

    public synchronized void add(ResourceCollection c) {
        if (this.m_rc == null) {
            this.m_rc = c;
            return;
        }
        if (!(this.m_rc instanceof Resources)) {
            Resources newRc = new Resources();
            newRc.setProject(this.getProject());
            newRc.add(this.m_rc);
            this.m_rc = newRc;
        }
        ((Resources)this.m_rc).add(c);
    }

    private ResourceCollection getResources() {
        if (this.m_rc == null) {
            return null;
        }
        Restrict noexistRc = new Restrict();
        noexistRc.add(NOT_EXISTS);
        noexistRc.add(this.m_rc);
        Iterator i = noexistRc.iterator();
        while (i.hasNext()) {
            this.log(i.next() + " does not exist.", 0);
        }
        if (this.m_destinationFile != null) {
            for (Object o : this.m_rc) {
                File f;
                if (!(o instanceof FileResource) || !FILE_UTILS.fileNameEquals(f = ((FileResource)o).getFile(), this.m_destinationFile)) continue;
                throw new BuildException("Input file \"" + f + "\" is the same as the output file.");
            }
        }
        Restrict result = new Restrict();
        result.add(EXISTS);
        result.add(this.m_rc);
        return result;
    }

    public void reset() {
        this.m_rc = null;
        this.m_destinationFile = null;
        this.m_compilationLevel = null;
    }

    public void execute() throws BuildException {
        if (this.m_destinationFile == null) {
            throw new BuildException("Must specify a JS file output");
        }
        if (this.getResources() == null) {
            return;
        }
        if (this.m_closureJar == null) {
            throw new BuildException("Must specify the closure compiler JAR file");
        }
        CommandlineJava cmdl = new CommandlineJava();
        cmdl.setClassname("com.google.javascript.jscomp.CommandLineRunner");
        cmdl.setCloneVm(true);
        cmdl.createClasspath(this.getProject());
        cmdl.getClasspath().add((ResourceCollection)new FileResource(this.m_closureJar));
        cmdl.getClasspath().add((ResourceCollection)new FileResource(new File(this.m_closureJar.getParent(), "args4j-2.0.16.jar")));
        cmdl.getClasspath().add((ResourceCollection)new FileResource(new File(this.m_closureJar.getParent(), "guava-14.0.jar")));
        cmdl.getClasspath().add((ResourceCollection)new FileResource(new File(this.m_closureJar.getParent(), "json-20090211.jar")));
        Commandline.Argument arg = cmdl.createArgument();
        StringBuffer sb = new StringBuffer();
        ResourceCollection c = this.getResources();
        Iterator i = c.iterator();
        long lastMod = -1L;
        while (i.hasNext()) {
            lastMod = Math.max(lastMod, ((FileResource)i.next()).getLastModified());
        }
        sb.append("--js_output_file ");
        sb.append(this.m_destinationFile.getAbsolutePath() + " ");
        if (this.m_destinationFile.lastModified() >= lastMod) {
            return;
        }
        i = c.iterator();
        while (i.hasNext()) {
            sb.append("--js ");
            sb.append(i.next() + " ");
        }
        if (this.m_compilationLevel != null) {
            sb.append("--compilation_level ");
            sb.append(this.m_compilationLevel + " ");
        }
        sb.append("--summary_detail_level ");
        sb.append(this.m_summaryDetail + " ");
        sb.append("--warning_level ");
        sb.append(this.m_warningLevel + " ");
        arg.setLine(sb.toString());
        Execute exe = new Execute();
        this.setupExecutable(exe, cmdl.getCommandline());
        int result = -1;
        try {
            result = exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        if (result != 0) {
            throw new BuildException("The Closure compiler did not complete successfully.  See the output for more details.");
        }
    }

    private void setupExecutable(Execute exe, String[] command) {
        exe.setAntRun(this.getProject());
        exe.setWorkingDirectory(this.getProject().getBaseDir());
        this.setupEnvironment(exe);
        this.setupCommandLine(exe, command);
    }

    private void setupEnvironment(Execute exe) {
        Environment env = new Environment();
        String[] environment = env.getVariables();
        if (environment != null) {
            for (int i = 0; i < environment.length; ++i) {
                this.log("Setting environment variable: " + environment[i], 3);
            }
        }
        exe.setNewenvironment(true);
        exe.setEnvironment(environment);
    }

    private void setupCommandLine(Execute exe, String[] command) {
        exe.setCommandline(command);
    }
}

