/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.specs2.control.eff.Eff;
import org.specs2.control.eff.Evaluate;
import org.specs2.control.eff.Fx1;
import org.specs2.control.eff.Fx3;
import org.specs2.control.eff.FxAppend;
import org.specs2.control.eff.MemberInOut;
import org.specs2.control.eff.MemberInOut$;
import org.specs2.control.eff.Safe;
import org.specs2.control.eff.Writer;
import org.specs2.control.package$Operations$;
import org.specs2.control.producer.Producer;
import org.specs2.control.producer.Producer$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.DirectoryPath$;
import org.specs2.io.FilePath;
import org.specs2.io.FilePath$;
import org.specs2.io.FilePathReader;
import org.specs2.io.Paths$;
import org.specs2.text.MD5$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public abstract class FilePathReader$class {
    public static Eff filePaths(FilePathReader $this, DirectoryPath dir2, String glob, boolean verbose) {
        return org.specs2.control.producer.package$.MODULE$.ProducerOps(org.specs2.control.producer.package$.MODULE$.ProducerOps(FilePathReader$class.filePathsProcess($this, dir2, MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R())), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R())).filter($this.filterWithPattern($this.globToPattern(glob))), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R())).runList();
    }

    public static Function1 filterWithPattern(FilePathReader $this, String pattern) {
        return new Serializable($this, pattern){
            public static final long serialVersionUID = 0L;
            private final String pattern$1;

            public final boolean apply(FilePath filePath) {
                return Paths$.MODULE$.Path(filePath.path().replaceFirst(".:", "")).unixize().matches(this.pattern$1);
            }
            {
                this.pattern$1 = pattern$1;
            }
        };
    }

    public static String globToPattern(FilePathReader $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        return glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
    }

    public static Eff listFilePaths(FilePathReader $this, DirectoryPath directory2) {
        return org.specs2.control.producer.package$.MODULE$.ProducerOps(FilePathReader$class.filePathsProcess($this, directory2, MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R())), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R())).runList();
    }

    public static Eff listDirectFilePaths(FilePathReader $this, DirectoryPath directory2) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, directory2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directory$1;

            public final IndexedSeq<FilePath> apply() {
                return (IndexedSeq)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)this.directory$1.toFile().listFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.IndexedSeq<File> apply(File[] x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$1).toIndexedSeq();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<Nothing$> apply() {
                        return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$2) {
                        return x$2.isFile();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilePath apply(File f) {
                        return FilePath$.MODULE$.unsafe(f);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.directory$1 = directory$1;
            }
        });
    }

    public static Eff listDirectDirectoryPaths(FilePathReader $this, DirectoryPath directory2) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, directory2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directory$2;

            public final IndexedSeq<DirectoryPath> apply() {
                return (IndexedSeq)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)this.directory$2.toFile().listFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.IndexedSeq<File> apply(File[] x$3) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$3).toIndexedSeq();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<Nothing$> apply() {
                        return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$4) {
                        return x$4.isDirectory();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DirectoryPath apply(File f) {
                        return DirectoryPath$.MODULE$.unsafe(f);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.directory$2 = directory$2;
            }
        });
    }

    private static Producer filePathsProcess(FilePathReader $this, DirectoryPath directory2, MemberInOut evidence$1) {
        return FilePathReader$class.go$1($this, directory2, evidence$1);
    }

    public static Eff readFile(FilePathReader $this, FilePath path2) {
        return $this.readLines(path2).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexedSeq<String> x$8) {
                return x$8.mkString("\n");
            }
        });
    }

    public static Eff readLines(FilePathReader $this, FilePath filePath) {
        return $this.readLinesWithCodec(filePath, Codec$.MODULE$.UTF8());
    }

    public static Eff readFileWithCodec(FilePathReader $this, FilePath path2, Codec codec) {
        return $this.readLinesWithCodec(path2, codec).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexedSeq<String> x$9) {
                return x$9.mkString("\n");
            }
        });
    }

    public static Eff readLinesWithCodec(FilePathReader $this, FilePath filePath, Codec codec) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, filePath, codec){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$1;
            private final Codec codec$1;

            public final scala.collection.immutable.IndexedSeq<String> apply() {
                return Source$.MODULE$.fromFile(this.filePath$1.path(), this.codec$1).getLines().toIndexedSeq();
            }
            {
                this.filePath$1 = filePath$1;
                this.codec$1 = codec$1;
            }
        });
    }

    public static Eff readBytes(FilePathReader $this, FilePath filePath) {
        return $this.exists(filePath).map(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$2;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(boolean exists2) {
                byte[] byArray;
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.filePath$2.path()));
                try {
                    byArray = (byte[])((TraversableOnce)package$.MODULE$.Stream().continually((Function0)new Serializable(this, stream){
                        public static final long serialVersionUID = 0L;
                        private final BufferedInputStream stream$1;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.stream$1.read();
                        }
                        {
                            this.stream$1 = stream$1;
                        }
                    }).takeWhile((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x) {
                            return this.apply$mcZI$sp(x);
                        }

                        public boolean apply$mcZI$sp(int x) {
                            return -1 != x;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final byte apply(int x$10) {
                            return (byte)x$10;
                        }
                    }, Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                stream.close();
                return byArray;
            }
            {
                this.filePath$2 = filePath$2;
            }
        });
    }

    public static Eff md5(FilePathReader $this, FilePath filePath) {
        return $this.readBytes(filePath).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] bytes) {
                return MD5$.MODULE$.md5Hex(bytes);
            }
        });
    }

    public static Eff exists(FilePathReader $this, FilePath filePath) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.filePath$3.toFile().exists();
            }
            {
                this.filePath$3 = filePath$3;
            }
        });
    }

    public static Eff doesNotExist(FilePathReader $this, FilePath filePath) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.filePath$4.toFile().exists();
            }
            {
                this.filePath$4 = filePath$4;
            }
        });
    }

    public static Eff exists(FilePathReader $this, DirectoryPath directoryPath) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, directoryPath){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directoryPath$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.directoryPath$1.toFile().exists();
            }
            {
                this.directoryPath$1 = directoryPath$1;
            }
        });
    }

    public static Eff doesNotExist(FilePathReader $this, DirectoryPath directoryPath) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, directoryPath){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directoryPath$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.directoryPath$2.toFile().exists();
            }
            {
                this.directoryPath$2 = directoryPath$2;
            }
        });
    }

    public static Eff mustExist(FilePathReader $this, File file2) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$1.exists();
            }
            {
                this.file$1 = file$1;
            }
        }).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(boolean exists2) {
                return exists2 ? package$Operations$.MODULE$.ok(BoxedUnit.UNIT) : package$Operations$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1})));
            }
            {
                this.file$1 = file$1;
            }
        });
    }

    public static Eff mustBeADirectory(FilePathReader $this, File file2) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$2.isDirectory();
            }
            {
                this.file$2 = file$2;
            }
        }).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(boolean isDirectory) {
                return isDirectory ? package$Operations$.MODULE$.ok(BoxedUnit.UNIT) : package$Operations$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2})));
            }
            {
                this.file$2 = file$2;
            }
        });
    }

    public static Eff mustNotBeADirectory(FilePathReader $this, File file2) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$3.isDirectory();
            }
            {
                this.file$3 = file$3;
            }
        }).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(boolean isDirectory) {
                return isDirectory ? package$Operations$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}))) : package$Operations$.MODULE$.ok(BoxedUnit.UNIT);
            }
            {
                this.file$3 = file$3;
            }
        });
    }

    public static final Producer go$1(FilePathReader $this, DirectoryPath dir2, MemberInOut evidence$1$1) {
        Tuple2 tuple22 = ((TraversableLike)Option$.MODULE$.apply((Object)dir2.toFile().listFiles()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<File> apply(File[] x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])x$5).toList();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).partition((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.isFile();
            }
        });
        if (tuple22 != null) {
            Tuple2 tuple23;
            List files = (List)tuple22._1();
            List directories = (List)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)files, (Object)directories);
            List files2 = (List)tuple24._1();
            List directories2 = (List)tuple24._2();
            return Producer$.MODULE$.emit((List)files2.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final FilePath apply(File f) {
                    return FilePath$.MODULE$.unsafe(f);
                }
            }, List$.MODULE$.canBuildFrom()), evidence$1$1).append(org.specs2.control.producer.package$.MODULE$.ProducerFlattenOps(Producer$.MODULE$.emit((List)((List)directories2.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final DirectoryPath apply(File f) {
                    return DirectoryPath$.MODULE$.unsafe(f);
                }
            }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, evidence$1$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FilePathReader $outer;
                private final MemberInOut evidence$1$1;

                public final Producer<Object, FilePath> apply(DirectoryPath dir2) {
                    return FilePathReader$class.go$1(this.$outer, dir2, this.evidence$1$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.evidence$1$1 = evidence$1$1;
                }
            }, List$.MODULE$.canBuildFrom()), evidence$1$1), evidence$1$1).flatten());
        }
        throw new MatchError((Object)tuple22);
    }

    public static void $init$(FilePathReader $this) {
    }
}

