/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sonar.runner.cache.FileCache;
import org.sonar.runner.cache.FileCacheBuilder;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.impl.JarExtractor;
import org.sonar.runner.impl.ServerConnection;

class Jars {
    private final FileCache fileCache;
    private final ServerConnection connection;
    private final JarExtractor jarExtractor;
    private final Logger logger;

    Jars(ServerConnection conn, JarExtractor jarExtractor, Logger logger, Properties props) {
        this.logger = logger;
        this.fileCache = new FileCacheBuilder(logger).setUserHome(props.getProperty("sonar.userHome")).build();
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    Jars(FileCache fileCache, ServerConnection conn, JarExtractor jarExtractor, Logger logger) {
        this.logger = logger;
        this.fileCache = fileCache;
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    FileCache getFileCache() {
        return this.fileCache;
    }

    List<File> download() {
        ArrayList<File> files = new ArrayList<File>();
        this.logger.debug("Extract sonar-runner-batch in temp...");
        files.add(this.jarExtractor.extractToTemp("sonar-runner-batch"));
        files.addAll(this.downloadFiles());
        return files;
    }

    private List<File> downloadFiles() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.logger.debug("Get bootstrap index...");
            String libs = this.connection.download("/batch_bootstrap/index");
            this.logger.debug("Get bootstrap completed");
            String[] lines = libs.split("[\r\n]+");
            BatchFileDownloader batchFileDownloader = new BatchFileDownloader(this.connection);
            for (String line : lines) {
                if ("".equals(line = line.trim())) continue;
                String[] libAndHash = line.split("\\|");
                String filename = libAndHash[0];
                String hash = libAndHash.length > 0 ? libAndHash[1] : "";
                files.add(this.fileCache.get(filename, hash, batchFileDownloader));
            }
            return files;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download libraries from server", e);
        }
    }

    static class BatchFileDownloader
    implements FileCache.Downloader {
        private final ServerConnection connection;

        BatchFileDownloader(ServerConnection conn) {
            this.connection = conn;
        }

        @Override
        public void download(String filename, File toFile) throws IOException {
            this.connection.downloadFile(String.format("/batch/%s", filename), toFile);
        }
    }
}

