/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class Utils {
    private Utils() {
    }

    public static void deleteQuietly(Path f) {
        try {
            Files.walkFileTree(f, new DeleteQuietlyFileVisitor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DeleteQuietlyFileVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteQuietlyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(file);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(file);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(dir);
        }

        private static FileVisitResult deleteAndContinue(Path path) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

