/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.internal.FlowLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.SecondaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.UnderlinedRange;

public class PrimaryLocation
extends PreciseLocation {
    @Nullable
    public Integer expectedAdditionalCount;
    public final List<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
    public final List<List<FlowLocation>> flowLocations = new ArrayList<List<FlowLocation>>();

    public PrimaryLocation(UnderlinedRange range, @Nullable Integer expectedAdditionalCount) {
        super(range);
        this.expectedAdditionalCount = expectedAdditionalCount;
    }

    public int secondaryAndFlowLocationCount() {
        return this.secondaryLocations.size() + this.flowLocations.stream().mapToInt(List::size).sum();
    }

    public SecondaryLocation addSecondary(UnderlinedRange range, @Nullable String message) {
        boolean primaryIsBefore = this.range.compareTo(range) <= 0;
        SecondaryLocation location = new SecondaryLocation(range, primaryIsBefore, this.secondaryLocations.size() + 1, message);
        this.secondaryLocations.add(location);
        return location;
    }

    @Override
    public void write(int indent, StringBuilder out, boolean primaryIsWritten) {
        this.range.underline(indent, out);
        if (this.expectedAdditionalCount != null) {
            out.append(' ').append(this.expectedAdditionalCount);
            int additionalCount = this.secondaryAndFlowLocationCount();
            if (this.expectedAdditionalCount != additionalCount) {
                out.append("[ERROR expect ").append(additionalCount).append("]");
            }
        }
    }
}

