/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating.xslt;

import java.util.Hashtable;
import java.util.Map;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemExtensionCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.cartridges.templating.xslt.DefaultMemberAccess;
import org.smooks.cartridges.templating.xslt.XslTemplateProcessor;

public class XalanJavabeanExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(XalanJavabeanExtension.class);
    private static final MemberAccess MEMBER_ACCESS = new DefaultMemberAccess();
    private static Hashtable<String, Object> expressionCache = new Hashtable();

    public Object select(XSLProcessorContext context, ElemExtensionCall element) throws OgnlException {
        AVT ognlAVT = element.getLiteralResultAttribute("ognl");
        if (ognlAVT == null) {
            throw new OgnlException("'ognl' expression attribute not specified.");
        }
        return this.select(ognlAVT.getSimpleString());
    }

    public Object select(String ognlExpression) throws OgnlException {
        if (ognlExpression == null || (ognlExpression = ognlExpression.trim()).equals("")) {
            throw new OgnlException("'ognl' expression not specified, or is blank.");
        }
        ExecutionContext activeRequest = XslTemplateProcessor.executionContextThreadLocal.get();
        if (activeRequest == null) {
            String message = this.getClass().getName() + " can only be used within the context of a SmooksDOMFilter operation..";
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        Map beans = activeRequest.getBeanContext().getBeanMap();
        Object parsedExpression = expressionCache.get(ognlExpression);
        if (parsedExpression == null) {
            try {
                parsedExpression = Ognl.parseExpression((String)ognlExpression);
                expressionCache.put(ognlExpression, parsedExpression);
            }
            catch (OgnlException e) {
                LOGGER.error("Exception parsing OGNL expression [" + ognlExpression + "].  Make sure the expression is properly constructed (http://www.ognl.org).", (Throwable)e);
                throw e;
            }
        }
        try {
            return Ognl.getValue((Object)parsedExpression, (OgnlContext)Ognl.createDefaultContext((Object)beans, (MemberAccess)MEMBER_ACCESS), (Object)beans);
        }
        catch (OgnlException e) {
            LOGGER.error("Unexpected exception using OGNL expression [" + ognlExpression + "] on Smooks Javabean cache.", (Throwable)e);
            throw e;
        }
    }
}

