/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.cartridges.templating.AbstractTemplateProcessor;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STRawGroupDir;
import org.w3c.dom.Element;

public class StringTemplateContentHandlerFactory
implements ContentHandlerFactory {
    @Inject
    private ApplicationContext applicationContext;

    public synchronized ContentHandler create(ResourceConfig resourceConfig) throws SmooksConfigException {
        StringTemplateTemplateProcessor stringTemplateTemplateProcessor = new StringTemplateTemplateProcessor();
        try {
            ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)stringTemplateTemplateProcessor, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), resourceConfig, (Object)stringTemplateTemplateProcessor)));
            return stringTemplateTemplateProcessor;
        }
        catch (SmooksConfigException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw new SmooksException(instanceException.getMessage(), (Throwable)instanceException);
        }
    }

    public String getType() {
        return "st";
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied StringTemplate Template.", detailTemplate="reporting/StringTemplateTemplateProcessor_After.html")
    private static class StringTemplateTemplateProcessor
    extends AbstractTemplateProcessor
    implements Consumer {
        private ST template = null;
        private String templateName;
        STRawGroupDir templateGroupDir;

        private StringTemplateTemplateProcessor() {
        }

        @Override
        protected void loadTemplate(ResourceConfig resourceConfig) throws IOException {
            String path = resourceConfig.getResource();
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String dir = path.substring(0, path.lastIndexOf(47));
            this.templateName = path.substring(path.lastIndexOf(47), path.indexOf(".st"));
            this.templateGroupDir = new STRawGroupDir(dir, this.getEncoding().displayName(), '$', '$');
            this.template = this.templateGroupDir.getInstanceOf(this.templateName);
        }

        protected void applyTemplate(ExecutionContext executionContext, Writer writer) {
            ST transform = this.templateGroupDir.getInstanceOf(this.templateName);
            Map beans = executionContext.getBeanContext().getBeanMap();
            for (Map.Entry entry : beans.entrySet()) {
                transform.add((String)entry.getKey(), entry.getValue());
            }
            String templatingResult = transform.render().trim();
            try {
                writer.write(templatingResult);
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean consumes(Object object) {
            return this.template.impl.getTemplateSource().contains(object.toString());
        }

        @Override
        protected void applyTemplate(Element element, ExecutionContext executionContext, Writer writer) {
            this.applyTemplate(executionContext, writer);
        }
    }
}

