/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating.freemarker;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.SecurityUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.cartridges.templating.AbstractTemplateProcessor;
import org.smooks.cartridges.templating.TemplatingConfiguration;
import org.smooks.cartridges.templating.freemarker.NodeModelSerializer;
import org.smooks.support.DomUtils;
import org.smooks.support.FreeMarkerUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(summary="FreeMarker Template - See Detail.", detailTemplate="reporting/FreeMarkerTemplateProcessor_before.html")
@VisitAfterReport(summary="FreeMarker Template - See Detail.", detailTemplate="reporting/FreeMarkerTemplateProcessor_After.html")
public class FreeMarkerTemplateProcessor
extends AbstractTemplateProcessor
implements Consumer {
    @Inject
    @Named(value="templating.freemarker.defaultNumberFormat")
    protected String defaultNumberFormat = "#.##########";
    @Inject
    protected Optional<String> baseDir;
    @Inject
    protected ApplicationContext applicationContext;
    protected Template defaultTemplate;
    protected Template templateBefore;
    protected Template templateAfter;
    protected ResourceConfig resourceConfig;

    protected FreeMarkerTemplateProcessor() {
    }

    public FreeMarkerTemplateProcessor(TemplatingConfiguration templatingConfiguration) {
        super.setTemplatingConfiguration(templatingConfiguration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void loadTemplate(ResourceConfig resourceConfig) throws IOException {
        this.resourceConfig = resourceConfig;
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_21);
        configuration.setSharedVariable("serialize", (TemplateModel)new NodeModelSerializer());
        configuration.setNumberFormat(this.defaultNumberFormat);
        if (resourceConfig.isInline()) {
            byte[] templateBytes = resourceConfig.getBytes();
            String[] templates = new String(templateBytes).split("<\\?TEMPLATE-SPLIT-PI\\?>");
            if (templates.length == 1) {
                this.defaultTemplate = new Template("free-marker-template", (Reader)new StringReader(templates[0]), configuration);
                return;
            } else {
                if (templates.length != 2) throw new IOException("Invalid FreeMarker template config. Zero split tokens.");
                this.templateBefore = new Template("free-marker-template-before", (Reader)new StringReader(templates[0]), configuration);
                this.templateAfter = new Template("free-marker-template-after", (Reader)new StringReader(templates[1]), configuration);
            }
            return;
        } else {
            File baseDirFile = this.baseDir.map(File::new).orElseGet(() -> new File(SecurityUtilities.getSystemProperty((String)"user.dir")));
            TemplateLoader[] loaders = new TemplateLoader[]{new FileTemplateLoader(baseDirFile), new ContextClassLoaderTemplateLoader(this.applicationContext.getClassLoader())};
            MultiTemplateLoader multiLoader = new MultiTemplateLoader(loaders);
            configuration.setTemplateLoader((TemplateLoader)multiLoader);
            this.defaultTemplate = configuration.getTemplate(resourceConfig.getResource());
        }
    }

    public boolean consumes(Object object) {
        if (this.defaultTemplate != null && this.defaultTemplate.toString().contains(object.toString())) {
            return true;
        }
        if (this.templateBefore != null && this.templateBefore.toString().contains(object.toString())) {
            return true;
        }
        return this.templateAfter != null && this.templateAfter.toString().contains(object.toString());
    }

    @Override
    protected void applyTemplate(Element element, ExecutionContext executionContext, Writer writer) {
        this.applyTemplate(this.defaultTemplate, element, executionContext, writer);
    }

    protected void applyTemplate(Template template, Element element, ExecutionContext executionContext, Writer writer) throws SmooksException {
        try {
            HashMap<String, NodeModel> model = new HashMap<String, NodeModel>(FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext));
            if (model.get(element.getNodeName()) == null) {
                model.put(element.getNodeName(), NodeModel.wrap((Node)element));
            }
            template.process(model, writer);
        }
        catch (TemplateException | IOException e) {
            throw new SmooksException(String.format("Failed to apply FreeMarker template to fragment [%s] from resource [%s]", DomUtils.getXPath((Node)element), this.resourceConfig), e);
        }
    }

    private static class ContextClassLoaderTemplateLoader
    extends URLTemplateLoader {
        private final ClassLoader classLoader;

        public ContextClassLoaderTemplateLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        protected URL getURL(String name) {
            return this.classLoader.getResource(name);
        }
    }
}

