/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.flatfile;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.cartridges.flatfile.Field;
import org.smooks.cartridges.flatfile.Record;
import org.smooks.cartridges.flatfile.RecordMetaData;
import org.smooks.cartridges.flatfile.RecordParser;
import org.smooks.cartridges.flatfile.RecordParserFactory;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FlatFileReader
implements SmooksXMLReader,
VisitorAppender {
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static final char[] INDENT_LF = new char[]{'\n'};
    private static final char[] INDENTCHARS = new char[]{'\t', '\t'};
    private static final String RECORD_NUMBER_ATTR = "number";
    private static final String RECORD_TRUNCATED_ATTR = "truncated";
    private ContentHandler contentHandler;
    private ExecutionContext execContext;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext appContext;
    @Inject
    @Named(value="parserFactory")
    private Class<? extends RecordParserFactory> parserFactoryClass;
    private RecordParserFactory parserFactory;
    @Inject
    private String rootElementName = "records";
    @Inject
    private Boolean indent = false;

    @PostConstruct
    public void initialize() throws IllegalAccessException, InstantiationException {
        this.parserFactory = this.parserFactoryClass.newInstance();
        ((LifecycleManager)this.appContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)this.parserFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.appContext.getRegistry(), this.resourceConfig, (Object)this.parserFactory)));
    }

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        if (this.parserFactory instanceof VisitorAppender) {
            return ((VisitorAppender)this.parserFactory).addVisitors();
        }
        return Collections.emptyList();
    }

    public void setExecutionContext(ExecutionContext request) {
        this.execContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse Record stream.");
        }
        if (this.execContext == null) {
            throw new IllegalStateException("'execContext' not set.  Cannot parse Record stream.");
        }
        try {
            RecordParser recordParser = this.parserFactory.newRecordParser();
            recordParser.setRecordParserFactory(this.parserFactory);
            recordParser.setDataSource(inputSource);
            try {
                recordParser.initialize();
                this.contentHandler.startDocument();
                this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
                int lineNumber = 0;
                Record record = recordParser.nextRecord();
                while (record != null) {
                    ++lineNumber;
                    List<Field> recordFields = record.getFields();
                    if (this.indent.booleanValue()) {
                        this.contentHandler.characters(INDENT_LF, 0, 1);
                        this.contentHandler.characters(INDENTCHARS, 0, 1);
                    }
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addAttribute("", RECORD_NUMBER_ATTR, RECORD_NUMBER_ATTR, "xs:int", Integer.toString(lineNumber));
                    RecordMetaData recordMetaData = record.getRecordMetaData();
                    if (recordFields.size() < recordMetaData.getUnignoredFieldCount()) {
                        attrs.addAttribute("", RECORD_TRUNCATED_ATTR, RECORD_TRUNCATED_ATTR, "xs:boolean", Boolean.TRUE.toString());
                    }
                    this.contentHandler.startElement("", record.getName(), "", attrs);
                    for (Field recordField : recordFields) {
                        String fieldName = recordField.getName();
                        if (this.indent.booleanValue()) {
                            this.contentHandler.characters(INDENT_LF, 0, 1);
                            this.contentHandler.characters(INDENTCHARS, 0, 2);
                        }
                        this.contentHandler.startElement("", fieldName, "", EMPTY_ATTRIBS);
                        String value = recordField.getValue();
                        this.contentHandler.characters(value.toCharArray(), 0, value.length());
                        this.contentHandler.endElement("", fieldName, "");
                    }
                    if (this.indent.booleanValue()) {
                        this.contentHandler.characters(INDENT_LF, 0, 1);
                        this.contentHandler.characters(INDENTCHARS, 0, 1);
                    }
                    this.contentHandler.endElement("", record.getName(), "");
                    record = recordParser.nextRecord();
                }
                if (this.indent.booleanValue()) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                }
                this.contentHandler.endElement("", this.rootElementName, "");
                this.contentHandler.endDocument();
            }
            finally {
                recordParser.uninitialize();
            }
        }
        finally {
            this.contentHandler = null;
            this.execContext = null;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void parse(String systemId) {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setFeature(String name, boolean value) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) {
    }
}

