/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.fixedlength.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import org.smooks.Smooks;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.fixedlength.FixedLengthBinding;
import org.smooks.cartridges.fixedlength.FixedLengthBindingType;
import org.smooks.cartridges.fixedlength.FixedLengthReaderConfigurator;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.source.ReaderSource;

public class FixedLengthMapBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public FixedLengthMapBinder(String fields, Class<?> recordType, String keyField) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull(recordType, (String)"recordType");
        AssertArgument.isNotNullAndNotEmpty((String)keyField, (String)"keyField");
        this.smooks = new Smooks();
        this.smooks.setReaderConfig((ReaderConfigurator)new FixedLengthReaderConfigurator(fields).setBinding(new FixedLengthBinding(this.beanId, recordType, FixedLengthBindingType.MAP).setKeyField(keyField)));
    }

    public Map bind(Reader fixedLengthStream) {
        AssertArgument.isNotNull((Object)fixedLengthStream, (String)"fixedLengthStream");
        JavaSink javaSink = new JavaSink();
        this.smooks.filterSource((Source)new ReaderSource(fixedLengthStream), new Sink[]{javaSink});
        return (Map)javaSink.getBean(this.beanId);
    }

    public Map bind(InputStream fixedLengthStream) {
        return this.bind(new InputStreamReader(fixedLengthStream));
    }
}

