/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.config.ProxyConfig;

class ProxyConfigImpl
implements ProxyConfig {
    @Nullable
    private final String remoteProxyHost;
    @Nullable
    private final Integer remoteProxyPort;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final Integer proxyBridgePort;

    ProxyConfigImpl(@Nullable String remoteProxyHost, @Nullable Integer remoteProxyPort, @Nullable String username, @Nullable String password, @Nullable Integer proxyBridgePort) {
        this.remoteProxyHost = remoteProxyHost;
        this.remoteProxyPort = remoteProxyPort;
        this.username = username;
        this.password = password;
        this.proxyBridgePort = proxyBridgePort;
    }

    public boolean requiresProxy() {
        return this.remoteProxyHost != null;
    }

    public boolean requiresAuthentication() {
        return this.username != null;
    }

    public String toString() {
        if (!this.requiresProxy()) {
            return "no-proxy";
        }
        String str = String.format("%s:%s", this.remoteProxyHost, this.remoteProxyPort);
        if (this.requiresAuthentication()) {
            str = str + String.format(", username: %s", this.username);
            str = str + String.format(", proxy bridge @ localhost:%s", this.proxyBridgePort);
        }
        return str;
    }

    @Nullable
    public Integer getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    @Nullable
    public String getRemoteProxyHost() {
        return this.remoteProxyHost;
    }

    @Nullable
    public Integer getRemoteProxyPort() {
        return this.remoteProxyPort;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }
}

