/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.OperationalConfig;

class OperationalConfigImpl
implements OperationalConfig {
    private final boolean async;
    private final Properties properties;
    private final int sessionTimeout;
    private final int threadPoolSize;
    private final int threadPoolKeepAliveTime;
    @NotNull
    private final UUID clusterKey;
    private final int connectionPoolCoreSize;
    private final int connectionPoolMaxSize;
    private final int connectionPoolClaimTimeoutMillis;
    private final int connectionPoolExpireAfterMillis;
    @NotNull
    private final LoadBalancingStrategy connectionPoolLoadBalancingStrategy;
    private final boolean transportModeLoggingOnly;
    private final boolean debugLogging;
    @NotNull
    private final List<String> sslHostsToTrust;
    private final boolean trustAllSSLHost;
    private final boolean verifyingServerIdentity;
    @NotNull
    private final ExecutorService executorService;
    private final boolean executorServiceIsUserProvided;
    @Nullable
    private final CustomMailer customMailer;

    public OperationalConfigImpl(boolean async, Properties properties, int sessionTimeout, int threadPoolSize, int threadPoolKeepAliveTime, @NotNull UUID clusterKey, int connectionPoolCoreSize, int connectionPoolMaxSize, int connectionPoolClaimTimeoutMillis, int connectionPoolExpireAfterMillis, @NotNull LoadBalancingStrategy connectionPoolLoadBalancingStrategy, boolean transportModeLoggingOnly, boolean debugLogging, @NotNull List<String> sslHostsToTrust, boolean trustAllSSLHost, boolean verifyingServerIdentity, @NotNull ExecutorService executorService, boolean executorServiceIsUserProvided, @Nullable CustomMailer customMailer) {
        if (clusterKey == null) {
            throw new NullPointerException("clusterKey is marked non-null but is null");
        }
        if (connectionPoolLoadBalancingStrategy == null) {
            throw new NullPointerException("connectionPoolLoadBalancingStrategy is marked non-null but is null");
        }
        if (sslHostsToTrust == null) {
            throw new NullPointerException("sslHostsToTrust is marked non-null but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        this.async = async;
        this.properties = properties;
        this.sessionTimeout = sessionTimeout;
        this.threadPoolSize = threadPoolSize;
        this.threadPoolKeepAliveTime = threadPoolKeepAliveTime;
        this.clusterKey = clusterKey;
        this.connectionPoolCoreSize = connectionPoolCoreSize;
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        this.connectionPoolClaimTimeoutMillis = connectionPoolClaimTimeoutMillis;
        this.connectionPoolExpireAfterMillis = connectionPoolExpireAfterMillis;
        this.connectionPoolLoadBalancingStrategy = connectionPoolLoadBalancingStrategy;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        this.debugLogging = debugLogging;
        this.sslHostsToTrust = sslHostsToTrust;
        this.trustAllSSLHost = trustAllSSLHost;
        this.verifyingServerIdentity = verifyingServerIdentity;
        this.executorService = executorService;
        this.executorServiceIsUserProvided = executorServiceIsUserProvided;
        this.customMailer = customMailer;
    }

    public String toString() {
        return "OperationalConfigImpl(async=" + this.isAsync() + ", properties=" + this.getProperties() + ", sessionTimeout=" + this.getSessionTimeout() + ", threadPoolSize=" + this.getThreadPoolSize() + ", threadPoolKeepAliveTime=" + this.getThreadPoolKeepAliveTime() + ", clusterKey=" + this.getClusterKey() + ", connectionPoolCoreSize=" + this.getConnectionPoolCoreSize() + ", connectionPoolMaxSize=" + this.getConnectionPoolMaxSize() + ", connectionPoolClaimTimeoutMillis=" + this.getConnectionPoolClaimTimeoutMillis() + ", connectionPoolExpireAfterMillis=" + this.getConnectionPoolExpireAfterMillis() + ", connectionPoolLoadBalancingStrategy=" + this.getConnectionPoolLoadBalancingStrategy() + ", transportModeLoggingOnly=" + this.isTransportModeLoggingOnly() + ", debugLogging=" + this.isDebugLogging() + ", sslHostsToTrust=" + this.getSslHostsToTrust() + ", trustAllSSLHost=" + this.isTrustAllSSLHost() + ", verifyingServerIdentity=" + this.isVerifyingServerIdentity() + ", executorService=" + this.getExecutorService() + ", executorServiceIsUserProvided=" + this.isExecutorServiceIsUserProvided() + ", customMailer=" + this.getCustomMailer() + ")";
    }

    public boolean isAsync() {
        return this.async;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getThreadPoolKeepAliveTime() {
        return this.threadPoolKeepAliveTime;
    }

    @NotNull
    public UUID getClusterKey() {
        return this.clusterKey;
    }

    public int getConnectionPoolCoreSize() {
        return this.connectionPoolCoreSize;
    }

    public int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    public int getConnectionPoolClaimTimeoutMillis() {
        return this.connectionPoolClaimTimeoutMillis;
    }

    public int getConnectionPoolExpireAfterMillis() {
        return this.connectionPoolExpireAfterMillis;
    }

    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy() {
        return this.connectionPoolLoadBalancingStrategy;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    @NotNull
    public List<String> getSslHostsToTrust() {
        return this.sslHostsToTrust;
    }

    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    @NotNull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isExecutorServiceIsUserProvided() {
        return this.executorServiceIsUserProvided;
    }

    @Nullable
    public CustomMailer getCustomMailer() {
        return this.customMailer;
    }
}

