/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import jakarta.activation.DataSource;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EqualsHelper {
    private static final Logger log = LoggerFactory.getLogger(EqualsHelper.class);

    public static boolean equalsEmail(Email email1, Email email2) {
        if (!EqualsHelper.fieldIsEqual(email1.getFromRecipient(), email2.getFromRecipient(), "fromRecipient")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getId(), email2.getId(), "id")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getSentDate(), email2.getSentDate(), "sendDate")) {
            return false;
        }
        if (!EqualsHelper.isEqualRecipientList("ReplyTo", email1.getReplyToRecipients(), email2.getReplyToRecipients())) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getBounceToRecipient(), email2.getBounceToRecipient(), "bounceToRecipient")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getPlainText(), email2.getPlainText(), "plainText")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getCalendarText(), email2.getCalendarText(), "calendarText")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual((Object)email1.getCalendarMethod(), (Object)email2.getCalendarMethod(), "calendarMethod")) {
            return false;
        }
        if (email1.getEmailToForward() != null ? email2.getEmailToForward() == null : email2.getEmailToForward() != null) {
            log.debug("Email unqual for emailToForward: {} vs {}", (Object)email1.getEmailToForward(), (Object)email2.getEmailToForward());
            return false;
        }
        if (email1.getHTMLText() != null ? !MiscUtil.normalizeNewlines(email1.getHTMLText()).equals(MiscUtil.normalizeNewlines(email2.getHTMLText())) : email2.getHTMLText() != null) {
            log.debug("Email unqual for HTML text: {} vs {}", (Object)email1.getHTMLText(), (Object)email2.getHTMLText());
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getSubject(), email2.getSubject(), "subject")) {
            return false;
        }
        if (!EqualsHelper.isEqualRecipientList("TO/CC/BCC", email1.getRecipients(), email2.getRecipients())) {
            return false;
        }
        if (!EqualsHelper.isEqualRecipientList("Override receivers", email1.getOverrideReceivers(), email2.getOverrideReceivers())) {
            return false;
        }
        if (!email1.getEmbeddedImages().containsAll(email2.getEmbeddedImages()) || !email2.getEmbeddedImages().containsAll(email1.getEmbeddedImages())) {
            log.debug("Email unqual for embedded images: {} vs {}", email1.getEmbeddedImages(), email2.getEmbeddedImages());
            return false;
        }
        if (!email1.getAttachments().containsAll(email2.getAttachments()) || !email2.getAttachments().containsAll(email1.getAttachments())) {
            log.debug("Email unqual for attachments: {} vs {}", email1.getAttachments(), email2.getAttachments());
            return false;
        }
        if (!email1.getHeaders().equals(email2.getHeaders())) {
            log.debug("Email unqual for headers: {} vs {}", email1.getHeaders(), email2.getHeaders());
            return false;
        }
        if (!Objects.equals(email1.getUseDispositionNotificationTo(), email2.getUseDispositionNotificationTo())) {
            log.debug("Email unqual for useDispositionNotificationTo: {} vs {}", (Object)email1.getUseDispositionNotificationTo(), (Object)email2.getUseDispositionNotificationTo());
            return false;
        }
        if (!Objects.equals(email1.getUseReturnReceiptTo(), email2.getUseReturnReceiptTo())) {
            log.debug("Email unqual for useReturnReceiptTo: {} vs {}", (Object)email1.getUseReturnReceiptTo(), (Object)email2.getUseReturnReceiptTo());
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getDispositionNotificationTo(), email2.getDispositionNotificationTo(), "dispositionNotificationTo")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getOriginalSmimeDetails(), email2.getOriginalSmimeDetails(), "originalSmimeDetails")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getPkcs12ConfigForSmimeSigning(), email2.getPkcs12ConfigForSmimeSigning(), "pkcs12ConfigForSmimeSigning")) {
            return false;
        }
        if (!EqualsHelper.fieldIsEqual(email1.getX509CertificateForSmimeEncryption(), email2.getX509CertificateForSmimeEncryption(), "x509CertificateForSmimeEncryption")) {
            return false;
        }
        return EqualsHelper.fieldIsEqual(email1.getReturnReceiptTo(), email2.getReturnReceiptTo(), "returnReceiptTo");
    }

    private static boolean isEqualRecipientList(String recipientType, List<Recipient> recipients, List<Recipient> otherRecipients) {
        if (recipients.size() != otherRecipients.size()) {
            log.debug("Email unqual for [{}] recipients: {} vs {}", new Object[]{recipientType, recipients, otherRecipients});
            return false;
        }
        for (Recipient otherRecipient : otherRecipients) {
            if (EqualsHelper.containsRecipient(recipients, otherRecipient)) continue;
            log.debug("Email unqual for recipients: {} vs {}", recipients, otherRecipients);
            return false;
        }
        return true;
    }

    private static boolean containsRecipient(List<Recipient> recipients, @Nullable Recipient otherRecipient) {
        for (Recipient recipient : recipients) {
            if (!Objects.equals(recipient, otherRecipient)) continue;
            return true;
        }
        return false;
    }

    static boolean isEqualDataSource(@Nullable DataSource a, @Nullable DataSource b) {
        return a == b || a != null && b != null && EqualsHelper.fieldIsEqual(a.getName(), b.getName(), "name") && EqualsHelper.fieldIsEqual(a.getContentType(), b.getContentType(), "contentType");
    }

    private static boolean fieldIsEqual(Object obj1, Object obj2, String name) {
        boolean isEqual = Objects.equals(obj1, obj2);
        if (!isEqual) {
            log.debug("Email unqual for {}: {} vs {}", new Object[]{name, obj1, obj2});
        }
        return isEqual;
    }
}

