/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.thread;

class ThreadBuilder {
    ThreadBuilder() {
    }

    public static Thread build(Runnable task) {
        Thread thread = ThreadBuilder.getThread(task);
        String name = ThreadBuilder.getName(task, thread);
        if (!thread.isAlive()) {
            thread.setName(name);
        }
        return thread;
    }

    public static Thread build(Runnable task, Class type) {
        Thread thread = ThreadBuilder.getThread(task);
        String name = ThreadBuilder.getName(type, thread);
        if (!thread.isAlive()) {
            thread.setName(name);
        }
        return thread;
    }

    private static String getName(Runnable task, Thread thread) {
        Class<?> type = task.getClass();
        return ThreadBuilder.getName(type, thread);
    }

    private static String getName(Class type, Thread thread) {
        String prefix = type.getSimpleName();
        String name = thread.getName();
        return String.format("%s: %s", prefix, name);
    }

    private static Thread getThread(Runnable task) {
        return new Thread(task);
    }
}

