/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import org.simpleframework.transport.Negotiation;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

abstract class Task
implements Operation {
    protected final Negotiation state;
    protected final Reactor reactor;
    protected final Trace trace;
    protected final int require;

    public Task(Negotiation state, Reactor reactor, Trace trace, int require) {
        this.reactor = reactor;
        this.require = require;
        this.state = state;
        this.trace = trace;
    }

    public SelectableChannel getChannel() {
        return this.state.getChannel();
    }

    public void run() {
        try {
            this.execute();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
            this.cancel();
        }
    }

    public void cancel() {
        try {
            this.state.cancel();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
        }
    }

    protected void execute() throws IOException {
        boolean done = this.ready();
        if (!done) {
            this.reactor.process(this, this.require);
        } else {
            this.state.resume();
        }
    }

    protected boolean ready() throws IOException {
        return true;
    }
}

