/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Dispatcher;
import org.simpleframework.transport.Handshake;
import org.simpleframework.transport.Negotiator;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketTransport;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.reactor.Operation;

class OperationFactory {
    private final Negotiator negotiator;
    private final int limit;
    private final boolean client;

    public OperationFactory(Negotiator negotiator, int limit) {
        this(negotiator, limit, false);
    }

    public OperationFactory(Negotiator negotiator, int limit, boolean client) {
        this.negotiator = negotiator;
        this.limit = limit;
        this.client = client;
    }

    public Operation getInstance(Socket socket) throws IOException {
        return this.getInstance(socket, socket.getEngine());
    }

    private Operation getInstance(Socket socket, SSLEngine engine) throws IOException {
        SocketTransport transport = new SocketTransport(socket, this.negotiator, this.limit);
        if (engine != null) {
            return new Handshake((Transport)transport, this.negotiator, this.client);
        }
        return new Dispatcher(transport, this.negotiator);
    }
}

