/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonStringBlock;

class JsonStringScanner {
    private static final long EVEN_BITS_MASK = 0x5555555555555555L;
    private static final long ODD_BITS_MASK = -6148914691236517206L;
    private final ByteVector backslashMask;
    private final ByteVector quoteMask;
    private long prevInString = 0L;
    private long prevEscaped = 0L;

    JsonStringScanner() {
        VectorSpecies species = ByteVector.SPECIES_256;
        this.backslashMask = ByteVector.broadcast((VectorSpecies)species, (byte)92);
        this.quoteMask = ByteVector.broadcast((VectorSpecies)species, (byte)34);
    }

    JsonStringBlock next(ByteVector chunk0, ByteVector chunk1) {
        long backslash = this.eq(chunk0, chunk1, this.backslashMask);
        long escaped = this.findEscaped(backslash);
        long quote = this.eq(chunk0, chunk1, this.quoteMask) & (escaped ^ 0xFFFFFFFFFFFFFFFFL);
        long inString = this.prefixXor(quote) ^ this.prevInString;
        this.prevInString = inString >> 63;
        return new JsonStringBlock(quote, inString);
    }

    private long eq(ByteVector chunk0, ByteVector chunk1, ByteVector mask) {
        long rLo = chunk0.eq((Vector)mask).toLong();
        long rHi = chunk1.eq((Vector)mask).toLong();
        return rLo | rHi << 32;
    }

    private long findEscaped(long backslash) {
        if (backslash == 0L) {
            long escaped = this.prevEscaped;
            this.prevEscaped = 0L;
            return escaped;
        }
        long followsEscape = (backslash &= this.prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | this.prevEscaped;
        long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
        long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
        this.prevEscaped = ((oddSequenceStarts ^ sequencesStartingOnEvenBits) & (backslash ^ sequencesStartingOnEvenBits)) >>> 63;
        long invertMask = sequencesStartingOnEvenBits << 1;
        return (0x5555555555555555L ^ invertMask) & followsEscape;
    }

    private long prefixXor(long bitmask) {
        bitmask ^= bitmask << 1;
        bitmask ^= bitmask << 2;
        bitmask ^= bitmask << 4;
        bitmask ^= bitmask << 8;
        bitmask ^= bitmask << 16;
        bitmask ^= bitmask << 32;
        return bitmask;
    }

    void reset() {
        this.prevInString = 0L;
        this.prevEscaped = 0L;
    }

    void finish() {
        if (this.prevInString != 0L) {
            throw new JsonParsingException("Unclosed string. A string is opened, but never closed.");
        }
    }
}

