/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.emulation;

import java.util.HashMap;
import java.util.Map;

public class GeolocationCoordinates {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public GeolocationCoordinates(double latitude, double longitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude must be between -90.0 and 90.0");
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude must be between -180.0 and 180.0");
        }
        this.map.put("latitude", latitude);
        this.map.put("longitude", longitude);
        this.map.put("accuracy", 1.0);
    }

    public GeolocationCoordinates accuracy(double accuracy) {
        if (accuracy < 0.0) {
            throw new IllegalArgumentException("Accuracy must be >= 0.0");
        }
        this.map.put("accuracy", accuracy);
        return this;
    }

    public GeolocationCoordinates altitude(Double altitude) {
        if (altitude != null) {
            this.map.put("altitude", altitude);
        }
        return this;
    }

    public GeolocationCoordinates altitudeAccuracy(Double altitudeAccuracy) {
        if (altitudeAccuracy != null) {
            if (!this.map.containsKey("altitude")) {
                throw new IllegalArgumentException("altitudeAccuracy cannot be set without altitude");
            }
            if (altitudeAccuracy < 0.0) {
                throw new IllegalArgumentException("Altitude accuracy must be >= 0.0");
            }
            this.map.put("altitudeAccuracy", altitudeAccuracy);
        }
        return this;
    }

    public GeolocationCoordinates heading(Double heading) {
        if (heading != null) {
            if (heading < 0.0 || heading >= 360.0) {
                throw new IllegalArgumentException("Heading must be between 0.0 and 360.0");
            }
            this.map.put("heading", heading);
        }
        return this;
    }

    public GeolocationCoordinates speed(Double speed) {
        if (speed != null) {
            if (speed < 0.0) {
                throw new IllegalArgumentException("Speed must be >= 0.0");
            }
            this.map.put("speed", speed);
        }
        return this;
    }

    public double getLatitude() {
        return (Double)this.map.get("latitude");
    }

    public double getLongitude() {
        return (Double)this.map.get("longitude");
    }

    public double getAccuracy() {
        return (Double)this.map.get("accuracy");
    }

    public Double getAltitude() {
        return (Double)this.map.get("altitude");
    }

    public Double getAltitudeAccuracy() {
        return (Double)this.map.get("altitudeAccuracy");
    }

    public Double getHeading() {
        return (Double)this.map.get("heading");
    }

    public Double getSpeed() {
        return (Double)this.map.get("speed");
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

