/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class DistributorStatus {
    private static final Type NODE_STATUSES_TYPE = new TypeToken<Set<NodeStatus>>(){}.getType();
    private final Set<NodeStatus> allNodes;

    public DistributorStatus(Collection<NodeStatus> allNodes) {
        this.allNodes = Collections.unmodifiableSet(new HashSet((Collection)Require.nonNull((String)"nodes", allNodes)));
    }

    public boolean hasCapacity() {
        return this.getNodes().stream().anyMatch(node -> node.getAvailability().equals((Object)Availability.UP) && node.hasCapacity());
    }

    public Set<NodeStatus> getNodes() {
        return this.allNodes;
    }

    private Map<String, Object> toJson() {
        return Collections.singletonMap("nodes", this.getNodes());
    }

    private static DistributorStatus fromJson(JsonInput input) {
        Set nodes = null;
        input.beginObject();
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodes": {
                    nodes = (Set)input.read(NODE_STATUSES_TYPE);
                    continue block6;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DistributorStatus(nodes);
    }
}

