/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.cli.WrappedPrintWriter;
import org.openqa.selenium.grid.config.Role;

public class Main {
    private final PrintStream out;
    private final PrintStream err;
    private final String[] args;

    public static void main(String[] args) {
        new Main(System.out, System.err, args).go();
    }

    Main(PrintStream out, PrintStream err, String[] args) {
        this.out = out;
        this.err = err;
        this.args = args;
    }

    void go() {
        if (this.args.length == 0) {
            this.showHelp(Main.class.getClassLoader());
        } else {
            this.launch(this.args, Main.class.getClassLoader());
        }
    }

    private static Set<CliCommand> loadCommands(ClassLoader loader) {
        TreeSet<CliCommand> commands = new TreeSet<CliCommand>(Comparator.comparing(CliCommand::getName));
        ServiceLoader.load(CliCommand.class, loader).forEach(commands::add);
        return commands;
    }

    private void showHelp(ClassLoader loader) {
        new Help(Main.loadCommands(loader)).configure(this.out, this.err, new String[0]).run();
    }

    private void launch(String[] args, ClassLoader loader) {
        String commandName = args[0];
        String[] remainingArgs = new String[args.length - 1];
        System.arraycopy(args, 1, remainingArgs, 0, args.length - 1);
        Set<CliCommand> commands = Main.loadCommands(loader);
        CliCommand command = commands.parallelStream().filter(cmd -> commandName.equals(cmd.getName())).findFirst().orElse(new Help(commands));
        command.configure(this.out, this.err, remainingArgs).run();
    }

    private static class Help
    implements CliCommand {
        private final Set<CliCommand> commands;

        public Help(Set<CliCommand> commands) {
            this.commands = commands;
        }

        @Override
        public String getName() {
            return "Selenium Server commands";
        }

        @Override
        public Set<Role> getConfigurableRoles() {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> getFlagObjects() {
            return Collections.emptySet();
        }

        @Override
        public String getDescription() {
            return "A list of all the commands available. To use one, run `java -jar selenium.jar commandName`.";
        }

        @Override
        public CliCommand.Executable configure(PrintStream out, PrintStream err, String ... args) {
            return () -> {
                int longest = this.commands.stream().filter(CliCommand::isShown).map(CliCommand::getName).max(Comparator.comparingInt(String::length)).map(String::length).orElse(0) + 2;
                WrappedPrintWriter outWriter = new WrappedPrintWriter((OutputStream)out, 72, 0);
                outWriter.append(this.getName()).append("\n\n");
                outWriter.append(this.getDescription()).append("\n").append("\n");
                int indent = Math.min(longest + 2, 25);
                String format = "  %-" + longest + "s";
                WrappedPrintWriter indented = new WrappedPrintWriter((OutputStream)out, 72, indent);
                this.commands.stream().filter(CliCommand::isShown).forEach(cmd -> indented.format(format, cmd.getName()).append(cmd.getDescription()).append("\n"));
                outWriter.write("\nFor each command, run with `--help` for command-specific help\n");
                outWriter.write("\nUse the `--ext` flag before the command name to specify an additional classpath to use with the server (for example, to provide additional commands, or to provide additional driver implementations). For example:\n");
                outWriter.write(String.format("%n  java -jar selenium.jar --ext example.jar%sdir standalone --port 1234", File.pathSeparator));
                out.println("\n");
            };
        }
    }
}

