/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class NodeStatus {
    private final NodeId nodeId;
    private final URI externalUri;
    private final int maxSessionCount;
    private final Set<Slot> slots;
    private final Availability availability;
    private final Duration heartbeatPeriod;
    private final String version;
    private final Map<String, String> osInfo;

    public NodeStatus(NodeId nodeId, URI externalUri, int maxSessionCount, Set<Slot> slots, Availability availability, Duration heartbeatPeriod, String version, Map<String, String> osInfo) {
        this.nodeId = (NodeId)Require.nonNull((String)"Node id", (Object)nodeId);
        this.externalUri = (URI)Require.nonNull((String)"URI", (Object)externalUri);
        this.maxSessionCount = Require.positive((String)"Max session count", (Integer)maxSessionCount, (String)"Make sure that a driver is available on $PATH");
        this.slots = Collections.unmodifiableSet(new HashSet((Collection)Require.nonNull((String)"Slots", slots)));
        this.availability = (Availability)((Object)Require.nonNull((String)"Availability", (Object)((Object)availability)));
        this.heartbeatPeriod = heartbeatPeriod;
        this.version = (String)Require.nonNull((String)"Grid Node version", (Object)version);
        this.osInfo = (Map)Require.nonNull((String)"Node host OS info", osInfo);
    }

    public static NodeStatus fromJson(JsonInput input) {
        NodeId nodeId = null;
        URI externalUri = null;
        int maxSessions = 0;
        Set slots = null;
        Availability availability = null;
        Duration heartbeatPeriod = null;
        String version = null;
        Map osInfo = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "availability": {
                    availability = (Availability)((Object)input.read(Availability.class));
                    continue block20;
                }
                case "heartbeatPeriod": {
                    heartbeatPeriod = Duration.ofMillis((Long)input.read(Long.class));
                    continue block20;
                }
                case "nodeId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block20;
                }
                case "maxSessions": {
                    maxSessions = (Integer)input.read(Integer.class);
                    continue block20;
                }
                case "slots": {
                    slots = (Set)input.read(new TypeToken<Set<Slot>>(){}.getType());
                    continue block20;
                }
                case "externalUri": {
                    externalUri = (URI)input.read(URI.class);
                    continue block20;
                }
                case "version": {
                    version = (String)input.read(String.class);
                    continue block20;
                }
                case "osInfo": {
                    osInfo = (Map)input.read(Map.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeStatus(nodeId, externalUri, maxSessions, slots, availability, heartbeatPeriod, version, osInfo);
    }

    public boolean hasCapability(Capabilities caps, SlotMatcher slotMatcher) {
        return this.slots.stream().anyMatch(slot -> slot.isSupporting(caps, slotMatcher));
    }

    public boolean hasCapacity() {
        return this.slots.stream().filter(slot -> slot.getSession() != null).count() < (long)this.maxSessionCount;
    }

    public boolean hasCapacity(Capabilities caps, SlotMatcher slotMatcher) {
        return this.slots.stream().filter(slot -> slot.getSession() != null).count() < (long)this.maxSessionCount && this.slots.stream().anyMatch(slot -> slot.getSession() == null && slot.isSupporting(caps, slotMatcher));
    }

    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public URI getExternalUri() {
        return this.externalUri;
    }

    public Set<Slot> getSlots() {
        return this.slots;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public Duration getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getOsInfo() {
        return this.osInfo;
    }

    public float getLoad() {
        float inUse = this.slots.parallelStream().filter(slot -> slot.getSession() != null).count();
        return inUse / (float)this.maxSessionCount * 100.0f;
    }

    public long getLastSessionCreated() {
        return this.slots.parallelStream().map(Slot::getLastStarted).mapToLong(Instant::toEpochMilli).max().orElse(0L);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.externalUri, that.externalUri) && this.maxSessionCount == that.maxSessionCount && Objects.equals(this.slots, that.slots) && Objects.equals((Object)this.availability, (Object)that.availability) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.externalUri, this.maxSessionCount, this.slots, this.version);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("nodeId", this.nodeId);
        toReturn.put("externalUri", this.externalUri);
        toReturn.put("maxSessions", this.maxSessionCount);
        toReturn.put("slots", this.slots);
        toReturn.put("availability", (Object)this.availability);
        toReturn.put("heartbeatPeriod", this.heartbeatPeriod.toMillis());
        toReturn.put("version", this.version);
        toReturn.put("osInfo", this.osInfo);
        return Collections.unmodifiableMap(toReturn);
    }
}

