package org.openqa.selenium.devtools.v95.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum AttributionReportingIssueType {

    PERMISSIONPOLICYDISABLED("PermissionPolicyDisabled"),
    INVALIDATTRIBUTIONSOURCEEVENTID("InvalidAttributionSourceEventId"),
    INVALIDATTRIBUTIONDATA("InvalidAttributionData"),
    ATTRIBUTIONSOURCEUNTRUSTWORTHYORIGIN("AttributionSourceUntrustworthyOrigin"),
    ATTRIBUTIONUNTRUSTWORTHYORIGIN("AttributionUntrustworthyOrigin"),
    ATTRIBUTIONTRIGGERDATATOOLARGE("AttributionTriggerDataTooLarge"),
    ATTRIBUTIONEVENTSOURCETRIGGERDATATOOLARGE("AttributionEventSourceTriggerDataTooLarge");

    private String value;

    AttributionReportingIssueType(String value) {
        this.value = value;
    }

    public static AttributionReportingIssueType fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
