/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.input.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class TouchPoint {
    private final Number x;
    private final Number y;
    private final Optional<Number> radiusX;
    private final Optional<Number> radiusY;
    private final Optional<Number> rotationAngle;
    private final Optional<Number> force;
    private final Optional<Number> id;

    public TouchPoint(Number x, Number y, Optional<Number> radiusX, Optional<Number> radiusY, Optional<Number> rotationAngle, Optional<Number> force, Optional<Number> id) {
        this.x = Objects.requireNonNull(x, "x is required");
        this.y = Objects.requireNonNull(y, "y is required");
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.rotationAngle = rotationAngle;
        this.force = force;
        this.id = id;
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public Optional<Number> getRadiusX() {
        return this.radiusX;
    }

    public Optional<Number> getRadiusY() {
        return this.radiusY;
    }

    public Optional<Number> getRotationAngle() {
        return this.rotationAngle;
    }

    public Optional<Number> getForce() {
        return this.force;
    }

    public Optional<Number> getId() {
        return this.id;
    }

    private static TouchPoint fromJson(JsonInput input) {
        Number x = 0;
        Number y = 0;
        Optional<Number> radiusX = Optional.empty();
        Optional<Number> radiusY = Optional.empty();
        Optional<Number> rotationAngle = Optional.empty();
        Optional<Number> force = Optional.empty();
        Optional<Number> id = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "x": {
                    x = input.nextNumber();
                    continue block18;
                }
                case "y": {
                    y = input.nextNumber();
                    continue block18;
                }
                case "radiusX": {
                    radiusX = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "radiusY": {
                    radiusY = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "rotationAngle": {
                    rotationAngle = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "force": {
                    force = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "id": {
                    id = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TouchPoint(x, y, radiusX, radiusY, rotationAngle, force, id);
    }
}

