/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.bluetoothemulation.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum CharacteristicOperationType {
    READ("read"),
    WRITE("write"),
    SUBSCRIBE_TO_NOTIFICATIONS("subscribe-to-notifications"),
    UNSUBSCRIBE_FROM_NOTIFICATIONS("unsubscribe-from-notifications");

    private String value;

    private CharacteristicOperationType(String value) {
        this.value = value;
    }

    public static CharacteristicOperationType fromString(String s) {
        return Arrays.stream(CharacteristicOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CharacteristicOperationType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CharacteristicOperationType fromJson(JsonInput input) {
        return CharacteristicOperationType.fromString(input.nextString());
    }
}

