package org.openqa.selenium.devtools.v142.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration for memory dump. Used only when "memory-infra" category is enabled.
 */
@org.openqa.selenium.Beta()
public class MemoryDumpConfig extends java.util.AbstractMap<String, Object> {

    private final java.util.Map<String, Object> memoryDumpConfig;

    public MemoryDumpConfig(java.util.Map<String, Object> memoryDumpConfig) {
        this.memoryDumpConfig = java.util.Objects.requireNonNull(memoryDumpConfig, "Missing value for MemoryDumpConfig");
    }

    public java.util.Set<java.util.Map.Entry<String, Object>> entrySet() {
        return memoryDumpConfig.entrySet();
    }

    public Object put(String key, Object value) {
        return memoryDumpConfig.put(key, value);
    }

    public boolean containsKey(String key) {
        return memoryDumpConfig.containsKey(key);
    }

    public Object get(String key) {
        return memoryDumpConfig.get(key);
    }

    protected java.util.Map<String, Object> delegate() {
        return memoryDumpConfig;
    }

    private static MemoryDumpConfig fromJson(JsonInput input) {
        return new MemoryDumpConfig((java.util.Map<String, Object>) input.read(java.util.Map.class));
    }

    public java.util.Map<String, Object> toJson() {
        return memoryDumpConfig;
    }

    public String toString() {
        return memoryDumpConfig.toString();
    }
}
