package org.openqa.selenium.devtools.v142.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * ContainerSelector physical axes
 */
public enum PhysicalAxes {

    HORIZONTAL("Horizontal"), VERTICAL("Vertical"), BOTH("Both");

    private String value;

    PhysicalAxes(String value) {
        this.value = value;
    }

    public static PhysicalAxes fromString(String s) {
        return java.util.Arrays.stream(PhysicalAxes.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PhysicalAxes "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PhysicalAxes fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
