/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.storage.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingVerboseDebugReportSent {
    private final String url;
    private final Optional<List<Map<String, Object>>> body;
    private final Optional<Integer> netError;
    private final Optional<String> netErrorName;
    private final Optional<Integer> httpStatusCode;

    public AttributionReportingVerboseDebugReportSent(String url, Optional<List<Map<String, Object>>> body, Optional<Integer> netError, Optional<String> netErrorName, Optional<Integer> httpStatusCode) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.body = body;
        this.netError = netError;
        this.netErrorName = netErrorName;
        this.httpStatusCode = httpStatusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<List<Map<String, Object>>> getBody() {
        return this.body;
    }

    public Optional<Integer> getNetError() {
        return this.netError;
    }

    public Optional<String> getNetErrorName() {
        return this.netErrorName;
    }

    public Optional<Integer> getHttpStatusCode() {
        return this.httpStatusCode;
    }

    private static AttributionReportingVerboseDebugReportSent fromJson(JsonInput input) {
        String url = null;
        Optional<List<Map<String, Object>>> body = Optional.empty();
        Optional<Integer> netError = Optional.empty();
        Optional<String> netErrorName = Optional.empty();
        Optional<Integer> httpStatusCode = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "body": {
                    body = Optional.ofNullable(input.readArray(Map.class));
                    continue block14;
                }
                case "netError": {
                    netError = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "netErrorName": {
                    netErrorName = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "httpStatusCode": {
                    httpStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingVerboseDebugReportSent(url, body, netError, netErrorName, httpStatusCode);
    }
}

