package org.openqa.selenium.devtools.v141.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class Player {

    private final org.openqa.selenium.devtools.v141.media.model.PlayerId playerId;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.dom.model.BackendNodeId> domNodeId;

    public Player(org.openqa.selenium.devtools.v141.media.model.PlayerId playerId, java.util.Optional<org.openqa.selenium.devtools.v141.dom.model.BackendNodeId> domNodeId) {
        this.playerId = java.util.Objects.requireNonNull(playerId, "playerId is required");
        this.domNodeId = domNodeId;
    }

    public org.openqa.selenium.devtools.v141.media.model.PlayerId getPlayerId() {
        return playerId;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v141.dom.model.BackendNodeId> getDomNodeId() {
        return domNodeId;
    }

    private static Player fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.media.model.PlayerId playerId = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.dom.model.BackendNodeId> domNodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "playerId":
                    playerId = input.read(org.openqa.selenium.devtools.v141.media.model.PlayerId.class);
                    break;
                case "domNodeId":
                    domNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Player(playerId, domNodeId);
    }
}
