/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v138.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPSocketOpened {
    private final RequestId identifier;
    private final String localAddr;
    private final Integer localPort;
    private final MonotonicTime timestamp;
    private final Optional<String> remoteAddr;
    private final Optional<Integer> remotePort;

    public DirectUDPSocketOpened(RequestId identifier, String localAddr, Integer localPort, MonotonicTime timestamp, Optional<String> remoteAddr, Optional<Integer> remotePort) {
        this.identifier = Objects.requireNonNull(identifier, "identifier is required");
        this.localAddr = Objects.requireNonNull(localAddr, "localAddr is required");
        this.localPort = Objects.requireNonNull(localPort, "localPort is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
    }

    public RequestId getIdentifier() {
        return this.identifier;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getRemoteAddr() {
        return this.remoteAddr;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    private static DirectUDPSocketOpened fromJson(JsonInput input) {
        RequestId identifier = null;
        String localAddr = null;
        Integer localPort = 0;
        MonotonicTime timestamp = null;
        Optional<String> remoteAddr = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "identifier": {
                    identifier = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "localAddr": {
                    localAddr = input.nextString();
                    continue block16;
                }
                case "localPort": {
                    localPort = input.nextNumber().intValue();
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block16;
                }
                case "remoteAddr": {
                    remoteAddr = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPSocketOpened(identifier, localAddr, localPort, timestamp, remoteAddr, remotePort);
    }
}

